/*
 * Decompiled with CFR 0.152.
 */
package es.uam.eps.ir.ranksys.rec.fast.basic;

import es.uam.eps.ir.ranksys.core.Recommendation;
import es.uam.eps.ir.ranksys.fast.FastRecommendation;
import es.uam.eps.ir.ranksys.fast.index.FastItemIndex;
import es.uam.eps.ir.ranksys.fast.index.FastUserIndex;
import es.uam.eps.ir.ranksys.rec.fast.AbstractFastRecommender;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.ranksys.core.util.tuples.Tuple2id;
import org.ranksys.core.util.tuples.Tuples;

public class RandomRecommender<U, I>
extends AbstractFastRecommender<U, I> {
    private final Random random = new Random();
    private final List<Tuple2id> randomList;

    public RandomRecommender(FastUserIndex<U> uIndex, FastItemIndex<I> iIndex) {
        super(uIndex, iIndex);
        this.randomList = iIndex.getAllIidx().mapToObj(iidx -> Tuples.tuple((int)iidx, (double)Double.NaN)).collect(Collectors.toList());
        Collections.shuffle(this.randomList);
    }

    @Override
    public FastRecommendation getRecommendation(int uidx, int maxLength, IntPredicate filter) {
        int s;
        int N = Math.min(maxLength, this.randomList.size());
        ArrayList<Tuple2id> recommended = new ArrayList<Tuple2id>();
        int j = s = this.random.nextInt(this.randomList.size());
        for (int i = 0; i < N; ++i) {
            Tuple2id iv = this.randomList.get(j);
            while (!filter.test(iv.v1)) {
                j = (j + 1) % this.randomList.size();
                iv = this.randomList.get(j);
            }
            recommended.add(iv);
            j = (j + 1) % this.randomList.size();
            if (s == j) break;
        }
        return new FastRecommendation(uidx, recommended);
    }

    @Override
    public Recommendation<U, I> getRecommendation(U u, Stream<I> candidates) {
        List items = candidates.map(i -> Tuples.tuple((Object)i, (double)Double.NaN)).collect(Collectors.toList());
        Collections.shuffle(items, this.random);
        return new Recommendation(u, items);
    }

    @Override
    public FastRecommendation getRecommendation(int uidx, IntStream candidates) {
        List items = candidates.mapToObj(iidx -> Tuples.tuple((int)iidx, (double)Double.NaN)).collect(Collectors.toList());
        Collections.shuffle(items, this.random);
        return new FastRecommendation(uidx, items);
    }
}

