/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;

public class MessageUtils {
    public static final String FACES_MESSAGES = "javax.faces.Messages";

    public static FacesMessage getMessage(Locale locale, FacesMessage.Severity severity, String key, Object ... params) {
        ResourceBundle bundle;
        String bundleName;
        String summary = null;
        String detail = null;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = application.getClass().getClassLoader();
        }
        if ((bundleName = application.getMessageBundle()) != null && (bundle = ResourceBundle.getBundle(bundleName, locale != null ? locale : context.getViewRoot().getLocale(), loader)) != null) {
            try {
                summary = bundle.getString(key);
                detail = bundle.getString(key + "_detail");
            }
            catch (MissingResourceException e) {
                detail = null;
            }
        }
        if (summary == null) {
            bundle = ResourceBundle.getBundle(FACES_MESSAGES, locale != null ? locale : context.getViewRoot().getLocale(), loader);
            if (bundle == null) {
                throw new NullPointerException();
            }
            try {
                summary = bundle.getString(key);
                detail = bundle.getString(key + "_detail");
            }
            catch (MissingResourceException e) {
                detail = null;
            }
        }
        if (summary != null && params != null) {
            summary = MessageFormat.format(summary, params);
        }
        if (detail != null && params != null) {
            detail = MessageFormat.format(detail, params);
        }
        if (summary != null) {
            return new FacesMessage(severity, summary, detail != null ? detail : "");
        }
        return new FacesMessage(severity, "???" + key + "???", detail != null ? detail : "");
    }

    public static FacesMessage getMessage(FacesMessage.Severity severity, String key, Object ... params) {
        return MessageUtils.getMessage(null, severity, key, params);
    }

    public static FacesMessage getMessage(Locale locale, String key, Object ... params) {
        return MessageUtils.getMessage(locale, FacesMessage.SEVERITY_ERROR, key, params);
    }

    public static FacesMessage getMessage(String key, Object ... params) {
        return MessageUtils.getMessage(null, FacesMessage.SEVERITY_ERROR, key, params);
    }
}

