/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.model.layout;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.primefaces.extensions.renderkit.layout.GsonLayoutOptions;

public class LayoutOptions
implements Serializable {
    private String id;
    private Map<String, Object> options = new HashMap<String, Object>();
    private LayoutOptions defaults;
    private LayoutOptions tips;
    private LayoutOptions north;
    private LayoutOptions south;
    private LayoutOptions west;
    private LayoutOptions east;
    private LayoutOptions center;
    private LayoutOptions child;

    public LayoutOptions() {
    }

    public LayoutOptions(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public void addOption(String key, Object value) {
        this.options.put(key, value);
    }

    public void addOptions(Map<String, Object> options) {
        options.putAll(options);
    }

    public void setPanesOptions(LayoutOptions layoutOptions) {
        this.defaults = layoutOptions;
    }

    public LayoutOptions getPanesOptions() {
        return this.defaults;
    }

    public final LayoutOptions getTips() {
        return this.tips;
    }

    public final void setTips(LayoutOptions tips) {
        this.tips = tips;
    }

    public void setNorthOptions(LayoutOptions layoutOptions) {
        this.north = layoutOptions;
    }

    public LayoutOptions getNorthOptions() {
        return this.north;
    }

    public void setSouthOptions(LayoutOptions layoutOptions) {
        this.south = layoutOptions;
    }

    public LayoutOptions getSouthOptions() {
        return this.south;
    }

    public void setWestOptions(LayoutOptions layoutOptions) {
        this.west = layoutOptions;
    }

    public LayoutOptions getWestOptions() {
        return this.west;
    }

    public void setEastOptions(LayoutOptions layoutOptions) {
        this.east = layoutOptions;
    }

    public LayoutOptions getEastOptions() {
        return this.east;
    }

    public void setCenterOptions(LayoutOptions layoutOptions) {
        this.center = layoutOptions;
    }

    public LayoutOptions getCenterOptions() {
        return this.center;
    }

    public void setChildOptions(LayoutOptions layoutOptions) {
        this.child = layoutOptions;
    }

    public LayoutOptions getChildOptions() {
        return this.child;
    }

    public Set<LayoutOptions> getDirectionPanes() {
        HashSet<LayoutOptions> result = new HashSet<LayoutOptions>();
        result.add(this.getCenterOptions());
        result.add(this.getNorthOptions());
        result.add(this.getEastOptions());
        result.add(this.getWestOptions());
        result.add(this.getSouthOptions());
        return result;
    }

    public LayoutOptions getLayoutOptions(String id) {
        if (id == null) {
            return null;
        }
        LayoutOptions loOptions = null;
        if (this.child != null) {
            if (id.equals(this.child.getId())) {
                return this.child;
            }
            loOptions = this.child.getLayoutOptions(id);
        }
        if (loOptions == null && this.defaults != null) {
            if (id.equals(this.defaults.getId())) {
                return this.defaults;
            }
            loOptions = this.defaults.getLayoutOptions(id);
        }
        if (loOptions == null && this.tips != null) {
            if (id.equals(this.tips.getId())) {
                return this.tips;
            }
            loOptions = this.tips.getLayoutOptions(id);
        }
        if (loOptions == null && this.center != null) {
            if (id.equals(this.center.getId())) {
                return this.center;
            }
            loOptions = this.center.getLayoutOptions(id);
        }
        if (loOptions == null && this.north != null) {
            if (id.equals(this.north.getId())) {
                return this.north;
            }
            loOptions = this.north.getLayoutOptions(id);
        }
        if (loOptions == null && this.south != null) {
            if (id.equals(this.south.getId())) {
                return this.south;
            }
            loOptions = this.south.getLayoutOptions(id);
        }
        if (loOptions == null && this.east != null) {
            if (id.equals(this.east.getId())) {
                return this.east;
            }
            loOptions = this.east.getLayoutOptions(id);
        }
        if (loOptions == null && this.west != null) {
            if (id.equals(this.west.getId())) {
                return this.west;
            }
            loOptions = this.west.getLayoutOptions(id);
        }
        return loOptions;
    }

    public boolean replace(String id, LayoutOptions layoutOptions) {
        boolean replaced = false;
        if (id == null) {
            return replaced;
        }
        if (this.child != null) {
            if (id.equals(this.child.getId())) {
                this.child = layoutOptions;
                return true;
            }
            replaced = this.child.replace(id, layoutOptions);
        }
        if (!replaced && this.defaults != null) {
            if (id.equals(this.defaults.getId())) {
                this.defaults = layoutOptions;
                return true;
            }
            replaced = this.defaults.replace(id, layoutOptions);
        }
        if (!replaced && this.tips != null) {
            if (id.equals(this.tips.getId())) {
                this.tips = layoutOptions;
                return true;
            }
            replaced = this.tips.replace(id, layoutOptions);
        }
        if (!replaced && this.center != null) {
            if (id.equals(this.center.getId())) {
                this.center = layoutOptions;
                return true;
            }
            replaced = this.center.replace(id, layoutOptions);
        }
        if (!replaced && this.north != null) {
            if (id.equals(this.north.getId())) {
                this.north = layoutOptions;
                return true;
            }
            replaced = this.north.replace(id, layoutOptions);
        }
        if (!replaced && this.south != null) {
            if (id.equals(this.south.getId())) {
                this.south = layoutOptions;
                return true;
            }
            replaced = this.south.replace(id, layoutOptions);
        }
        if (!replaced && this.east != null) {
            if (id.equals(this.east.getId())) {
                this.east = layoutOptions;
                return true;
            }
            replaced = this.east.replace(id, layoutOptions);
        }
        if (!replaced && this.west != null) {
            if (id.equals(this.west.getId())) {
                this.west = layoutOptions;
                return true;
            }
            replaced = this.west.replace(id, layoutOptions);
        }
        return replaced;
    }

    public String toJson() {
        return GsonLayoutOptions.getGson().toJson((Object)this);
    }
}

