/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Checksum {
    private static final String HEXES = "0123456789abcdef";
    private static final Logger LOGGER = LoggerFactory.getLogger(Checksum.class);
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA1";
    private static final String SHA256 = "SHA-256";
    private static final Map<String, Map<File, byte[]>> CHECKSUM_CACHES = new HashMap<String, Map<File, byte[]>>(3);

    private Checksum() {
    }

    public static byte[] getChecksum(String algorithm, File file) throws NoSuchAlgorithmException, IOException {
        Map<File, byte[]> checksumCache = CHECKSUM_CACHES.get(algorithm.toUpperCase());
        if (checksumCache == null) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        byte[] checksum = checksumCache.get(file);
        if (checksum == null) {
            HashFunction hashFunction = null;
            switch (algorithm.toUpperCase()) {
                case "MD5": {
                    hashFunction = Hashing.md5();
                    break;
                }
                case "SHA1": {
                    hashFunction = Hashing.sha1();
                    break;
                }
                case "SHA-256": {
                    hashFunction = Hashing.sha256();
                    break;
                }
                default: {
                    throw new NoSuchAlgorithmException(algorithm);
                }
            }
            HashCode hash = Files.asByteSource((File)file).hash(hashFunction);
            checksum = hash.asBytes();
            checksumCache.put(file, checksum);
        }
        return checksum;
    }

    public static String getMD5Checksum(File file) throws IOException, NoSuchAlgorithmException {
        byte[] b = Checksum.getChecksum(MD5, file);
        return Checksum.getHex(b);
    }

    public static String getSHA1Checksum(File file) throws IOException, NoSuchAlgorithmException {
        byte[] b = Checksum.getChecksum(SHA1, file);
        return Checksum.getHex(b);
    }

    public static String getSHA256Checksum(File file) throws IOException, NoSuchAlgorithmException {
        byte[] b = Checksum.getChecksum(SHA256, file);
        return Checksum.getHex(b);
    }

    public static String getChecksum(String algorithm, byte[] bytes) {
        MessageDigest digest = Checksum.getMessageDigest(algorithm);
        byte[] b = digest.digest(bytes);
        return Checksum.getHex(b);
    }

    public static String getMD5Checksum(String text) {
        byte[] data = Checksum.stringToBytes(text);
        return Checksum.getChecksum(MD5, data);
    }

    public static String getSHA1Checksum(String text) {
        byte[] data = Checksum.stringToBytes(text);
        return Checksum.getChecksum(SHA1, data);
    }

    public static String getSHA256Checksum(String text) {
        byte[] data = Checksum.stringToBytes(text);
        return Checksum.getChecksum(SHA256, data);
    }

    private static byte[] stringToBytes(String text) {
        byte[] data;
        try {
            data = text.getBytes(Charset.forName(StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedCharsetException ex) {
            data = text.getBytes(Charset.defaultCharset());
        }
        return data;
    }

    public static String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    private static MessageDigest getMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            String msg = String.format("Failed to obtain the %s message digest.", algorithm);
            throw new IllegalStateException(msg, e);
        }
    }

    static {
        CHECKSUM_CACHES.put(MD5, new ConcurrentHashMap());
        CHECKSUM_CACHES.put(SHA256, new ConcurrentHashMap());
        CHECKSUM_CACHES.put(SHA1, new ConcurrentHashMap());
    }
}

