/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.mvc.result;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.http.H;
import org.osgl.mvc.result.Result;
import org.osgl.storage.ISObject;
import org.osgl.storage.impl.SObject;
import org.osgl.util.E;
import org.osgl.util.Output;
import org.osgl.util.S;

public class RenderBinary
extends Result {
    private Disposition disposition = Disposition.inline;
    private long length;
    private String name;
    private SObject binary;
    private String contentType;
    private Osgl.Visitor<Output> contentWriter;

    public RenderBinary(InputStream is, String name) {
        this(is, name, false);
    }

    public RenderBinary(InputStream is, String name, long length) {
        this(is, name, length, false);
    }

    public RenderBinary(InputStream is, String name, boolean inline) {
        this(is, name, null, inline);
    }

    public RenderBinary(InputStream is, String name, String contentType, boolean inline) {
        this.binary = SObject.of((String)name, (InputStream)is);
        this.name = name;
        this.contentType = contentType;
        this.disposition = Disposition.of(inline);
    }

    public RenderBinary(InputStream is, String name, long length, String contentType, boolean inline) {
        this.binary = SObject.of((String)name, (InputStream)is);
        this.name = name;
        this.contentType = contentType;
        this.disposition = Disposition.of(inline);
        this.length = length;
    }

    public RenderBinary(InputStream is, String name, long length, boolean inline) {
        this.binary = SObject.of((String)name, (InputStream)is);
        this.name = name;
        this.length = length;
        this.disposition = Disposition.of(inline);
    }

    public RenderBinary(File file, String name) {
        this(file, name, false);
    }

    public RenderBinary(File file) {
        this(file, file.getName(), true);
    }

    public RenderBinary(File file, String name, boolean inline) {
        this.binary = SObject.of((String)name, (File)((File)$.notNull((Object)file)));
        this.name = name;
        this.disposition = Disposition.of(inline);
    }

    public RenderBinary(Osgl.Visitor<Output> contentWriter) {
        this.contentWriter = (Osgl.Visitor)$.notNull(contentWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(H.Request req, H.Response resp) {
        boolean hasName = S.notBlank((String)this.name);
        try {
            this.applyCookies(resp);
            this.applyHeaders(resp);
            if (null != this.contentType) {
                resp.contentType(this.contentType);
            } else if (hasName) {
                H.Format format;
                String ext = S.afterLast((String)this.name, (String)".");
                if (S.notBlank((String)ext) && null != (format = H.Format.of((String)ext))) {
                    resp.initContentType(format.contentType());
                }
                resp.initContentType("application/octet-stream");
            }
            if (!resp.containsHeader("Content-Disposition")) {
                resp.contentDisposition(this.name, this.disposition.isInline());
            }
            if (!resp.containsHeader("Content-Length") && 0L < this.length) {
                resp.header("Content-Length", S.string((Object)this.length));
            }
            this.applyStatus(resp);
            this.applyBeforeCommitHandler(req, resp);
            if (null != this.binary) {
                resp.writeBinary((ISObject)this.binary);
            } else {
                this.contentWriter.apply((Object)resp.output());
            }
        }
        catch (Exception e) {
            throw E.unexpected((Throwable)e);
        }
        finally {
            try {
                resp.commit();
                this.applyAfterCommitHandler(req, resp);
            }
            finally {
                RenderBinary.clearThreadLocals();
            }
        }
    }

    private boolean canAsciiEncode(String string) {
        CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();
        return asciiEncoder.canEncode(string);
    }

    private static enum Disposition {
        inline,
        attachment;


        public boolean isInline() {
            return inline == this;
        }

        public boolean isAttachment() {
            return attachment == this;
        }

        public static Disposition of(boolean inline) {
            return inline ? Disposition.inline : attachment;
        }
    }
}

