/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.spin.impl.json.jackson.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import org.operaton.spin.SpinList;
import org.operaton.spin.impl.json.jackson.JacksonJsonLogger;
import org.operaton.spin.impl.json.jackson.JacksonJsonNode;
import org.operaton.spin.impl.json.jackson.format.JacksonJsonDataFormat;
import org.operaton.spin.json.SpinJsonNode;
import org.operaton.spin.json.SpinJsonPathQuery;

public class JacksonJsonPathQuery
implements SpinJsonPathQuery {
    private static final JacksonJsonLogger LOG = JacksonJsonLogger.JSON_TREE_LOGGER;
    protected final SpinJsonNode spinJsonNode;
    protected final JsonPath query;
    protected final JacksonJsonDataFormat dataFormat;

    public JacksonJsonPathQuery(JacksonJsonNode jacksonJsonNode, JsonPath query, JacksonJsonDataFormat dataFormat) {
        this.spinJsonNode = jacksonJsonNode;
        this.query = query;
        this.dataFormat = dataFormat;
    }

    public SpinJsonNode element() {
        try {
            Object result = this.query.read(this.spinJsonNode.toString(), this.dataFormat.getJsonPathConfiguration());
            JsonNode node = result != null ? this.dataFormat.createJsonNode(result) : this.dataFormat.createNullJsonNode();
            return this.dataFormat.createWrapperInstance(node);
        }
        catch (PathNotFoundException pex) {
            throw LOG.unableToEvaluateJsonPathExpressionOnNode(this.spinJsonNode, (Exception)((Object)pex));
        }
        catch (ClassCastException cex) {
            throw LOG.unableToCastJsonPathResultTo(SpinJsonNode.class, cex);
        }
        catch (InvalidPathException iex) {
            throw LOG.invalidJsonPath(SpinJsonNode.class, (Exception)((Object)iex));
        }
    }

    public SpinList<SpinJsonNode> elementList() {
        JacksonJsonNode node = (JacksonJsonNode)this.element();
        if (Boolean.TRUE.equals(node.isArray())) {
            return node.elements();
        }
        throw LOG.unableToParseValue(SpinList.class.getSimpleName(), node.getNodeType());
    }

    public String stringValue() {
        JacksonJsonNode node = (JacksonJsonNode)this.element();
        if (Boolean.TRUE.equals(node.isString())) {
            return node.stringValue();
        }
        throw LOG.unableToParseValue(String.class.getSimpleName(), node.getNodeType());
    }

    public Number numberValue() {
        JacksonJsonNode node = (JacksonJsonNode)this.element();
        if (Boolean.TRUE.equals(node.isNumber())) {
            return node.numberValue();
        }
        throw LOG.unableToParseValue(Number.class.getSimpleName(), node.getNodeType());
    }

    public Boolean boolValue() {
        JacksonJsonNode node = (JacksonJsonNode)this.element();
        if (Boolean.TRUE.equals(node.isBoolean())) {
            return node.boolValue();
        }
        throw LOG.unableToParseValue(Boolean.class.getSimpleName(), node.getNodeType());
    }
}

