/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.spin.impl.json.jackson.format;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.TypeVariable;
import java.util.List;
import org.operaton.spin.impl.json.jackson.format.AbstractJacksonJsonTypeDetector;

public class ListJacksonJsonTypeDetector
extends AbstractJacksonJsonTypeDetector {
    public boolean canHandle(Object object) {
        return object instanceof List;
    }

    public String detectType(Object object) {
        return this.constructType(object).toCanonical();
    }

    protected JavaType constructType(Object object) {
        List list;
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        if (object instanceof List && !(list = (List)object).isEmpty()) {
            Object firstElement = list.get(0);
            if (this.bindingsArePresent(list.getClass())) {
                JavaType elementType = this.constructType(firstElement);
                return typeFactory.constructCollectionType(list.getClass(), elementType);
            }
        }
        return typeFactory.constructType(object.getClass());
    }

    private boolean bindingsArePresent(Class<?> erasedType) {
        int varLen;
        TypeVariable<Class<?>>[] vars = erasedType.getTypeParameters();
        int n = varLen = vars == null ? 0 : vars.length;
        if (varLen == 0) {
            return false;
        }
        if (varLen != 1) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + erasedType.getName() + " with 1 type parameter: class expects " + varLen);
        }
        return true;
    }
}

