/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.spin.impl.json.jackson.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import org.operaton.spin.impl.json.jackson.JacksonJsonLogger;
import org.operaton.spin.impl.json.jackson.format.JacksonJsonDataFormat;
import org.operaton.spin.spi.TextBasedDataFormatReader;

public class JacksonJsonDataFormatReader
extends TextBasedDataFormatReader {
    private static final JacksonJsonLogger JSON_LOGGER = JacksonJsonLogger.JSON_TREE_LOGGER;
    private static final Pattern INPUT_MATCHING_PATTERN = Pattern.compile("\\A(\\s)*[{\\[]");
    protected JacksonJsonDataFormat format;

    public JacksonJsonDataFormatReader(JacksonJsonDataFormat format) {
        this.format = format;
    }

    public Object readInput(Reader input) {
        ObjectMapper mapper = this.format.getObjectMapper();
        try {
            JsonNode jsonNode = mapper.readTree(input);
            if (jsonNode instanceof MissingNode) {
                throw new IOException("Input is empty");
            }
            return jsonNode;
        }
        catch (IOException e) {
            throw JSON_LOGGER.unableToParseInput(e);
        }
    }

    protected Pattern getInputDetectionPattern() {
        return INPUT_MATCHING_PATTERN;
    }
}

