/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.commons.logging;

import java.lang.reflect.InvocationTargetException;
import org.operaton.commons.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public abstract class BaseLogger {
    protected Logger delegateLogger;
    protected String projectCode;
    protected String componentId;

    protected BaseLogger() {
    }

    public static <T extends BaseLogger> T createLogger(Class<T> loggerClass, String projectCode, String name, String componentId) {
        try {
            BaseLogger logger = (BaseLogger)loggerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            logger.projectCode = projectCode;
            logger.componentId = componentId;
            logger.delegateLogger = LoggerFactory.getLogger((String)name);
            return (T)logger;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to instantiate logger '" + loggerClass.getName() + "'", e);
        }
    }

    protected void log(String level, String id, String messageTemplate, Object ... parameters) {
        this.log(level, Level.DEBUG, id, messageTemplate, parameters);
    }

    protected void log(String level, Level defaultLevel, String id, String messageTemplate, Object ... parameters) {
        switch (Level.parse(level, defaultLevel)) {
            case ERROR: {
                this.logError(id, messageTemplate, parameters);
                break;
            }
            case WARN: {
                this.logWarn(id, messageTemplate, parameters);
                break;
            }
            case INFO: {
                this.logInfo(id, messageTemplate, parameters);
                break;
            }
            case DEBUG: {
                this.logDebug(id, messageTemplate, parameters);
                break;
            }
            case TRACE: {
                this.logTrace(id, messageTemplate, parameters);
            }
        }
    }

    protected void logTrace(String id, String messageTemplate, Object ... parameters) {
        if (this.isTraceEnabled()) {
            String msg = this.formatMessageTemplate(id, messageTemplate);
            this.delegateLogger.trace(msg, this.sanitizeParameters(parameters));
        }
    }

    protected void logDebug(String id, String messageTemplate, Object ... parameters) {
        if (this.isDebugEnabled()) {
            String msg = this.formatMessageTemplate(id, messageTemplate);
            this.delegateLogger.debug(msg, this.sanitizeParameters(parameters));
        }
    }

    protected void logInfo(String id, String messageTemplate, Object ... parameters) {
        if (this.isInfoEnabled()) {
            String msg = this.formatMessageTemplate(id, messageTemplate);
            this.delegateLogger.info(msg, this.sanitizeParameters(parameters));
        }
    }

    protected void logWarn(String id, String messageTemplate, Object ... parameters) {
        if (this.isWarnEnabled()) {
            String msg = this.formatMessageTemplate(id, messageTemplate);
            this.delegateLogger.warn(msg, this.sanitizeParameters(parameters));
        }
    }

    protected void logError(String id, String messageTemplate, Object ... parameters) {
        if (this.isErrorEnabled()) {
            String msg = this.formatMessageTemplate(id, messageTemplate);
            this.delegateLogger.error(msg, this.sanitizeParameters(parameters));
        }
    }

    public boolean isTraceEnabled() {
        return this.delegateLogger.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.delegateLogger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.delegateLogger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.delegateLogger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.delegateLogger.isErrorEnabled();
    }

    protected String formatMessageTemplate(String id, String messageTemplate) {
        return this.projectCode + "-" + this.componentId + id + " " + messageTemplate;
    }

    protected String exceptionMessage(String id, String messageTemplate, Object ... parameters) {
        String formattedTemplate = this.formatMessageTemplate(id, messageTemplate);
        if (parameters == null || parameters.length == 0) {
            return formattedTemplate;
        }
        return MessageFormatter.arrayFormat((String)formattedTemplate, (Object[])parameters).getMessage();
    }

    Object[] sanitizeParameters(Object ... parameters) {
        if (parameters == null) {
            return null;
        }
        Object[] sanitized = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            sanitized[i] = this.sanitize(parameters[i]);
        }
        return sanitized;
    }

    private Object sanitize(Object parameter) {
        if (parameter instanceof String) {
            String param = (String)parameter;
            return param.replaceAll("[\n\r\t]", "_");
        }
        return parameter;
    }
}

