/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.webapp.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.Set;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.rest.spi.ProcessEngineProvider;
import org.operaton.bpm.webapp.AppRuntimeDelegate;
import org.operaton.bpm.webapp.plugin.AppPluginRegistry;
import org.operaton.bpm.webapp.plugin.impl.DefaultAppPluginRegistry;
import org.operaton.bpm.webapp.plugin.resource.PluginResourceOverride;
import org.operaton.bpm.webapp.plugin.spi.AppPlugin;

public abstract class AbstractAppRuntimeDelegate<T extends AppPlugin>
implements AppRuntimeDelegate<T> {
    protected final AppPluginRegistry<T> pluginRegistry;
    protected final ProcessEngineProvider processEngineProvider;
    protected List<PluginResourceOverride> resourceOverrides;

    protected AbstractAppRuntimeDelegate(Class<T> pluginType) {
        this.pluginRegistry = new DefaultAppPluginRegistry<T>(pluginType);
        this.processEngineProvider = this.loadProcessEngineProvider();
    }

    @Override
    public ProcessEngine getProcessEngine(String processEngineName) {
        try {
            return this.processEngineProvider.getProcessEngine(processEngineName);
        }
        catch (Exception e) {
            throw new ProcessEngineException("No process engine with name " + processEngineName + " found.", (Throwable)e);
        }
    }

    @Override
    public Set<String> getProcessEngineNames() {
        return this.processEngineProvider.getProcessEngineNames();
    }

    @Override
    public ProcessEngine getDefaultProcessEngine() {
        return this.processEngineProvider.getDefaultProcessEngine();
    }

    @Override
    public AppPluginRegistry<T> getAppPluginRegistry() {
        return this.pluginRegistry;
    }

    protected ProcessEngineProvider loadProcessEngineProvider() {
        ServiceLoader<ProcessEngineProvider> loader = ServiceLoader.load(ProcessEngineProvider.class);
        try {
            return loader.iterator().next();
        }
        catch (NoSuchElementException e) {
            String message = "No implementation for the %s spi found on classpath".formatted(ProcessEngineProvider.class.getName());
            throw new IllegalStateException(message, e);
        }
    }

    @Override
    public List<PluginResourceOverride> getResourceOverrides() {
        if (this.resourceOverrides == null) {
            this.initResourceOverrides();
        }
        return this.resourceOverrides;
    }

    protected synchronized void initResourceOverrides() {
        if (this.resourceOverrides == null) {
            this.resourceOverrides = new ArrayList<PluginResourceOverride>();
            List<T> plugins = this.pluginRegistry.getPlugins();
            for (AppPlugin p : plugins) {
                this.resourceOverrides.addAll(p.getResourceOverrides());
            }
        }
    }
}

