/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.webapp.plugin.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.operaton.bpm.webapp.plugin.AppPluginRegistry;
import org.operaton.bpm.webapp.plugin.spi.AppPlugin;

public class DefaultAppPluginRegistry<T extends AppPlugin>
implements AppPluginRegistry<T> {
    protected final Class<T> pluginType;
    protected Map<String, T> pluginsMap;

    public DefaultAppPluginRegistry(Class<T> pluginType) {
        this.pluginType = pluginType;
    }

    protected void loadPlugins() {
        ServiceLoader loader = ServiceLoader.load(this.pluginType);
        Iterator iterator = loader.iterator();
        HashMap<String, AppPlugin> map = new HashMap<String, AppPlugin>();
        while (iterator.hasNext()) {
            AppPlugin plugin = (AppPlugin)iterator.next();
            map.put(plugin.getId(), plugin);
        }
        this.pluginsMap = map;
    }

    public List<T> getPlugins() {
        if (this.pluginsMap == null) {
            this.loadPlugins();
        }
        return new ArrayList(this.pluginsMap.values());
    }

    public T getPlugin(String id) {
        if (this.pluginsMap == null) {
            this.loadPlugins();
        }
        return (T)((AppPlugin)this.pluginsMap.get(id));
    }
}

