/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.webapp.impl.security.filter.headersec;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.webapp.impl.security.filter.headersec.provider.HeaderSecurityProvider;
import org.operaton.bpm.webapp.impl.security.filter.headersec.provider.impl.ContentSecurityPolicyProvider;
import org.operaton.bpm.webapp.impl.security.filter.headersec.provider.impl.ContentTypeOptionsProvider;
import org.operaton.bpm.webapp.impl.security.filter.headersec.provider.impl.StrictTransportSecurityProvider;
import org.operaton.bpm.webapp.impl.security.filter.headersec.provider.impl.XssProtectionProvider;

public class HttpHeaderSecurityFilter
implements Filter {
    protected final List<HeaderSecurityProvider> headerSecurityProviders = List.of(new XssProtectionProvider(), new ContentSecurityPolicyProvider(), new ContentTypeOptionsProvider(), new StrictTransportSecurityProvider());

    public void init(FilterConfig filterConfig) {
        for (HeaderSecurityProvider provider : this.headerSecurityProviders) {
            Map filterParams = provider.initParams();
            for (Map.Entry entry : filterParams.entrySet()) {
                String key = (String)entry.getKey();
                String value = filterConfig.getInitParameter(key);
                if (value == null) continue;
                entry.setValue(value);
            }
            provider.parseParams();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            for (HeaderSecurityProvider provider : this.headerSecurityProviders) {
                if (provider.isDisabled()) continue;
                String headerName = provider.getHeaderName();
                String headerValue = provider.getHeaderValue(request.getServletContext());
                httpResponse.setHeader(headerName, headerValue);
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

