/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.webapp.impl.security.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RequestFilter {
    protected String[] methods;
    protected Pattern pattern;
    private String[] groups;

    public RequestFilter(String pattern, String applicationPath, String ... methods) {
        this.methods = methods;
        this.setPattern(pattern, applicationPath);
    }

    public Map<String, String> match(String requestMethod, String requestUri) {
        if (!this.isMethodMatched(requestMethod)) {
            return null;
        }
        return this.matchRequestUri(requestUri);
    }

    protected boolean isMethodMatched(String requestMethod) {
        boolean isMethodMatched = false;
        if (this.methods.length != 0) {
            for (String method : this.methods) {
                if (!method.equals(requestMethod)) continue;
                isMethodMatched = true;
                break;
            }
        } else {
            isMethodMatched = true;
        }
        return isMethodMatched;
    }

    protected Map<String, String> matchRequestUri(String requestUri) {
        Matcher matcher = this.pattern.matcher(requestUri);
        if (!matcher.matches()) {
            return null;
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = 0; i < matcher.groupCount(); ++i) {
            attributes.put(this.groups[i], matcher.group(i + 1));
        }
        return attributes;
    }

    protected final void setPattern(String pattern, String applicationPath) {
        String[] parts = pattern.split("/");
        ArrayList<String> groupList = new ArrayList<String>();
        StringBuilder regexBuilder = new StringBuilder();
        if (!applicationPath.isEmpty()) {
            regexBuilder.append(applicationPath);
        }
        boolean first = true;
        for (String part : parts) {
            String group = null;
            Object regex = part;
            if (part.startsWith("{") && part.endsWith("}")) {
                String groupStr = part.substring(1, part.length() - 1);
                String[] groupSplit = groupStr.split(":");
                if (groupSplit.length > 2) {
                    throw new IllegalArgumentException("cannot parse uri part " + (String)regex + " in " + pattern + ": expected {asdf(:pattern)}");
                }
                group = groupSplit[0];
                regex = groupSplit.length > 1 ? "(" + groupSplit[1] + ")" : "([^/]+)";
            }
            if (!first) {
                regexBuilder.append("/");
            } else {
                first = false;
            }
            regexBuilder.append((String)regex);
            if (group == null) continue;
            groupList.add(group);
        }
        this.groups = groupList.toArray(new String[0]);
        this.pattern = Pattern.compile(regexBuilder.toString());
    }
}

