/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.webapp.impl.security.filter;

import jakarta.servlet.FilterConfig;
import java.util.Arrays;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.util.StringUtil;
import org.operaton.bpm.webapp.impl.security.filter.CookieConfigurator;
import org.operaton.bpm.webapp.impl.security.filter.util.CookieConstants;

/*
 * Exception performing whole class analysis ignored.
 */
public class CookieConfigurator {
    protected static final String ENABLE_SECURE_PARAM = "enableSecureCookie";
    protected static final String ENABLE_SAME_SITE_PARAM = "enableSameSiteCookie";
    protected static final String SAME_SITE_OPTION_PARAM = "sameSiteCookieOption";
    protected static final String SAME_SITE_VALUE_PARAM = "sameSiteCookieValue";
    protected boolean isSecureCookieEnabled;
    protected boolean isSameSiteCookieEnabled;
    protected String sameSiteCookieValue;
    protected String cookieName;

    public void parseParams(FilterConfig filterConfig) {
        String enableSameSiteCookieInitParam;
        String sessionCookieName;
        String enableSecureCookieInitParam = filterConfig.getInitParameter("enableSecureCookie");
        if (StringUtil.hasText((String)enableSecureCookieInitParam)) {
            this.isSecureCookieEnabled = Boolean.parseBoolean(enableSecureCookieInitParam);
        }
        if (StringUtil.hasText((String)(sessionCookieName = filterConfig.getServletContext().getSessionCookieConfig().getName())) && !"JSESSIONID".equals(sessionCookieName)) {
            this.cookieName = sessionCookieName;
        }
        this.isSameSiteCookieEnabled = StringUtil.hasText((String)(enableSameSiteCookieInitParam = filterConfig.getInitParameter("enableSameSiteCookie"))) ? Boolean.parseBoolean(enableSameSiteCookieInitParam) : true;
        String sameSiteCookieValueInitParam = filterConfig.getInitParameter("sameSiteCookieValue");
        String sameSiteCookieOptionInitParam = filterConfig.getInitParameter("sameSiteCookieOption");
        this.sameSiteCookieValue = CookieConfigurator.getSameSiteCookieValueInitValue((String)sameSiteCookieValueInitParam, (String)sameSiteCookieOptionInitParam);
    }

    public String getConfig() {
        return this.getConfig(null);
    }

    public String getConfig(String currentHeader) {
        StringBuilder stringBuilder = new StringBuilder(currentHeader == null ? "" : currentHeader);
        if (this.isSameSiteCookieEnabled && (currentHeader == null || !CookieConstants.SAME_SITE_FIELD_NAME_REGEX.matcher(currentHeader).find())) {
            stringBuilder.append(";SameSite=").append(this.sameSiteCookieValue);
        }
        if (this.isSecureCookieEnabled && (currentHeader == null || !CookieConstants.SECURE_FLAG_NAME_REGEX.matcher(currentHeader).find())) {
            stringBuilder.append(";Secure");
        }
        return stringBuilder.toString();
    }

    public String getCookieName(String defaultName) {
        return StringUtil.hasText((String)this.cookieName) ? this.cookieName : defaultName;
    }

    static String getSameSiteCookieValueInitValue(String sameSiteCookieValueInitParam, String sameSiteCookieOptionInitParam) {
        if (StringUtil.hasText((String)sameSiteCookieValueInitParam) && StringUtil.hasText((String)sameSiteCookieOptionInitParam)) {
            throw new ProcessEngineException("Please either configure sameSiteCookieOption or sameSiteCookieValue.");
        }
        if (StringUtil.hasText((String)sameSiteCookieValueInitParam)) {
            return sameSiteCookieValueInitParam;
        }
        if (StringUtil.hasText((String)sameSiteCookieOptionInitParam)) {
            if (sameSiteCookieOptionInitParam.equalsIgnoreCase(SameSiteOption.LAX.name())) {
                return SameSiteOption.LAX.getValue();
            }
            if (sameSiteCookieOptionInitParam.equalsIgnoreCase(SameSiteOption.STRICT.name())) {
                return SameSiteOption.STRICT.getValue();
            }
            throw new ProcessEngineException("For sameSiteCookieOption param, please configure one of the following options: " + Arrays.toString(Arrays.stream(SameSiteOption.values()).map(SameSiteOption::getValue).toArray(String[]::new)));
        }
        return SameSiteOption.LAX.getValue();
    }
}

