/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.webapp.impl.security.auth;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.webapp.impl.security.auth.Authentication;
import org.operaton.bpm.webapp.impl.security.auth.UserAuthentication;

public class Authentications
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<Authentications> currentAuthentications = new ThreadLocal();
    private final Map<String, UserAuthentication> engineName2UserAuthentication = new HashMap();

    public Authentication getAuthenticationForProcessEngine(String engineName) {
        return (Authentication)this.engineName2UserAuthentication.get(engineName);
    }

    public void addOrReplace(UserAuthentication authentication) {
        this.engineName2UserAuthentication.put(authentication.getProcessEngineName(), authentication);
    }

    public UserAuthentication removeByEngineName(String engineName) {
        return (UserAuthentication)this.engineName2UserAuthentication.remove(engineName);
    }

    public List<UserAuthentication> getAuthentications() {
        return new ArrayList<UserAuthentication>(this.engineName2UserAuthentication.values());
    }

    public boolean hasAuthenticationForProcessEngine(String engineName) {
        return this.getAuthenticationForProcessEngine(engineName) != null;
    }

    public static void setCurrent(Authentications auth) {
        currentAuthentications.set(auth);
    }

    public static void clearCurrent() {
        currentAuthentications.remove();
    }

    public static Authentications getCurrent() {
        return (Authentications)currentAuthentications.get();
    }
}

