/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.cockpit.plugin.resource;

import java.util.List;
import org.operaton.bpm.cockpit.Cockpit;
import org.operaton.bpm.cockpit.db.CommandExecutor;
import org.operaton.bpm.cockpit.db.QueryParameters;
import org.operaton.bpm.cockpit.db.QueryService;
import org.operaton.bpm.cockpit.plugin.spi.CockpitPlugin;
import org.operaton.bpm.engine.authorization.Permission;
import org.operaton.bpm.engine.authorization.Resource;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.db.AuthorizationCheck;
import org.operaton.bpm.engine.impl.db.PermissionCheck;
import org.operaton.bpm.engine.impl.db.TenantCheck;
import org.operaton.bpm.engine.impl.identity.Authentication;
import org.operaton.bpm.webapp.AppRuntimeDelegate;
import org.operaton.bpm.webapp.plugin.resource.AbstractAppPluginResource;

public class AbstractCockpitPluginResource
extends AbstractAppPluginResource<CockpitPlugin> {
    public AbstractCockpitPluginResource(String engineName) {
        super((AppRuntimeDelegate)Cockpit.getRuntimeDelegate(), engineName);
    }

    protected CommandExecutor getCommandExecutor() {
        return Cockpit.getCommandExecutor((String)this.engineName);
    }

    protected QueryService getQueryService() {
        return Cockpit.getQueryService((String)this.engineName);
    }

    protected boolean isAuthorizationEnabled() {
        return this.getProcessEngine().getProcessEngineConfiguration().isAuthorizationEnabled();
    }

    protected boolean isTenantCheckEnabled() {
        return this.getProcessEngine().getProcessEngineConfiguration().isTenantCheckEnabled() && this.getCurrentAuthentication() != null && !this.isOperatonAdmin(this.getCurrentAuthentication());
    }

    protected boolean isOperatonAdmin(Authentication authentication) {
        String userId;
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)this.getProcessEngine().getProcessEngineConfiguration();
        List groupIds = authentication.getGroupIds();
        if (groupIds != null) {
            List adminGroups = engineConfiguration.getAdminGroups();
            for (String adminGroup : adminGroups) {
                if (!groupIds.contains(adminGroup)) continue;
                return true;
            }
        }
        if ((userId = authentication.getUserId()) != null) {
            List adminUsers = engineConfiguration.getAdminUsers();
            return adminUsers != null && adminUsers.contains(userId);
        }
        return false;
    }

    protected Authentication getCurrentAuthentication() {
        return this.getProcessEngine().getIdentityService().getCurrentAuthentication();
    }

    protected void configureAuthorizationCheck(QueryParameters query) {
        Authentication currentAuthentication = this.getCurrentAuthentication();
        AuthorizationCheck authCheck = query.getAuthCheck();
        authCheck.getPermissionChecks().clear();
        if (this.isAuthorizationEnabled() && currentAuthentication != null) {
            authCheck.setAuthorizationCheckEnabled(true);
            String currentUserId = currentAuthentication.getUserId();
            List currentGroupIds = currentAuthentication.getGroupIds();
            authCheck.setAuthUserId(currentUserId);
            authCheck.setAuthGroupIds(currentGroupIds);
        }
    }

    protected void configureTenantCheck(QueryParameters query) {
        TenantCheck tenantCheck = query.getTenantCheck();
        if (this.isTenantCheckEnabled()) {
            Authentication currentAuthentication = this.getCurrentAuthentication();
            tenantCheck.setTenantCheckEnabled(true);
            tenantCheck.setAuthTenantIds(currentAuthentication.getTenantIds());
        } else {
            tenantCheck.setTenantCheckEnabled(false);
            tenantCheck.setAuthTenantIds(null);
        }
    }

    protected void addPermissionCheck(QueryParameters query, Resource resource, String queryParam, Permission permission) {
        if (!this.isPermissionDisabled(permission)) {
            PermissionCheck permCheck = new PermissionCheck();
            permCheck.setResource(resource);
            permCheck.setResourceIdQueryParam(queryParam);
            permCheck.setPermission(permission);
            query.getAuthCheck().addAtomicPermissionCheck(permCheck);
        }
    }

    protected boolean isPermissionDisabled(Permission permission) {
        List disabledPermissions = this.getProcessEngine().getProcessEngineConfiguration().getDisabledPermissions();
        for (String disabledPerm : disabledPermissions) {
            if (disabledPerm.equals(permission.getName())) continue;
            return true;
        }
        return false;
    }
}

