/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.cockpit.impl.plugin.base.sub.resources;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import org.operaton.bpm.cockpit.db.QueryParameters;
import org.operaton.bpm.cockpit.db.QueryService;
import org.operaton.bpm.cockpit.impl.plugin.base.dto.ProcessDefinitionDto;
import org.operaton.bpm.cockpit.impl.plugin.base.dto.query.ProcessDefinitionQueryDto;
import org.operaton.bpm.cockpit.impl.plugin.base.sub.resources.ProcessDefinitionResource;
import org.operaton.bpm.cockpit.plugin.resource.AbstractPluginResource;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.authorization.Permission;
import org.operaton.bpm.engine.authorization.Permissions;
import org.operaton.bpm.engine.authorization.Resource;
import org.operaton.bpm.engine.authorization.Resources;
import org.operaton.bpm.engine.impl.interceptor.Command;

public class ProcessDefinitionResource
extends AbstractPluginResource {
    protected String id;

    public ProcessDefinitionResource(String engineName, String id) {
        super(engineName);
        this.id = id;
    }

    @GET
    @Path(value="/called-process-definitions")
    @Produces(value={"application/json"})
    public List<ProcessDefinitionDto> getCalledProcessDefinitions(@Context UriInfo uriInfo) {
        ProcessDefinitionQueryDto queryParameter = new ProcessDefinitionQueryDto(uriInfo.getQueryParameters());
        return this.queryCalledProcessDefinitions(queryParameter);
    }

    @POST
    @Path(value="/called-process-definitions")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<ProcessDefinitionDto> queryCalledProcessDefinitions(ProcessDefinitionQueryDto queryParameter) {
        return (List)this.getCommandExecutor().executeCommand((Command)new QueryCalledProcessDefinitionsCmd(this, queryParameter));
    }

    protected void configureExecutionQuery(ProcessDefinitionQueryDto query) {
        this.configureAuthorizationCheck((QueryParameters)query);
        this.configureTenantCheck((QueryParameters)query);
        this.addPermissionCheck((QueryParameters)query, (Resource)Resources.PROCESS_INSTANCE, "EXEC2.PROC_INST_ID_", (Permission)Permissions.READ);
        this.addPermissionCheck((QueryParameters)query, (Resource)Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", (Permission)Permissions.READ_INSTANCE);
    }

    static /* synthetic */ QueryService access$000(ProcessDefinitionResource x0) {
        return x0.getQueryService();
    }

    static /* synthetic */ ProcessEngine access$100(ProcessDefinitionResource x0) {
        return x0.getProcessEngine();
    }
}

