/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.cockpit.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.cockpit.CockpitRuntimeDelegate;
import org.operaton.bpm.cockpit.db.CommandExecutor;
import org.operaton.bpm.cockpit.db.QueryService;
import org.operaton.bpm.cockpit.impl.db.CommandExecutorImpl;
import org.operaton.bpm.cockpit.impl.db.QueryServiceImpl;
import org.operaton.bpm.cockpit.impl.plugin.DefaultPluginRegistry;
import org.operaton.bpm.cockpit.plugin.PluginRegistry;
import org.operaton.bpm.cockpit.plugin.spi.CockpitPlugin;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.ProcessEngineImpl;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.webapp.impl.AbstractAppRuntimeDelegate;

public class DefaultCockpitRuntimeDelegate
extends AbstractAppRuntimeDelegate<CockpitPlugin>
implements CockpitRuntimeDelegate {
    private final Map<String, CommandExecutor> commandExecutors = new HashMap();

    public DefaultCockpitRuntimeDelegate() {
        super(CockpitPlugin.class);
    }

    public QueryService getQueryService(String processEngineName) {
        CommandExecutor commandExecutor = this.getCommandExecutor(processEngineName);
        return new QueryServiceImpl(commandExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandExecutor getCommandExecutor(String processEngineName) {
        Map map = this.commandExecutors;
        synchronized (map) {
            return this.commandExecutors.computeIfAbsent(processEngineName, arg_0 -> this.createCommandExecutor(arg_0));
        }
    }

    @Deprecated(forRemoval=true, since="1.0")
    public PluginRegistry getPluginRegistry() {
        return new DefaultPluginRegistry(this.pluginRegistry);
    }

    protected List<String> getMappingFiles() {
        List cockpitPlugins = this.pluginRegistry.getPlugins();
        ArrayList<String> mappingFiles = new ArrayList<String>();
        for (CockpitPlugin plugin : cockpitPlugins) {
            mappingFiles.addAll(plugin.getMappingFiles());
        }
        return mappingFiles;
    }

    protected CommandExecutor createCommandExecutor(String processEngineName) {
        ProcessEngine processEngine = this.getProcessEngine(processEngineName);
        if (processEngine == null) {
            throw new ProcessEngineException("No process engine with name " + processEngineName + " found.");
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        List mappingFiles = this.getMappingFiles();
        return new CommandExecutorImpl(processEngineConfiguration, mappingFiles);
    }
}

