/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.spring.boot.starter.event;

import java.util.Arrays;
import java.util.List;
import org.operaton.bpm.engine.delegate.DelegateListener;
import org.operaton.bpm.engine.delegate.ExecutionListener;
import org.operaton.bpm.engine.delegate.TaskListener;
import org.operaton.bpm.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.operaton.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import org.operaton.bpm.engine.impl.core.model.CoreModelElement;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.pvm.process.ScopeImpl;
import org.operaton.bpm.engine.impl.pvm.process.TransitionImpl;
import org.operaton.bpm.engine.impl.task.TaskDefinition;
import org.operaton.bpm.engine.impl.util.xml.Element;
import org.operaton.bpm.spring.boot.starter.event.ExecutionEvent;
import org.operaton.bpm.spring.boot.starter.event.TaskEvent;
import org.operaton.bpm.spring.boot.starter.property.EventingProperty;
import org.springframework.context.ApplicationEventPublisher;

public class PublishDelegateParseListener
implements BpmnParseListener {
    private static final List<String> TASK_EVENTS = Arrays.asList("complete", "assignment", "create", "delete", "update");
    private static final List<String> EXECUTION_EVENTS = Arrays.asList("start", "end");
    private final TaskListener taskListener;
    private final ExecutionListener executionListener;
    private final boolean skippable;

    public PublishDelegateParseListener(ApplicationEventPublisher publisher, EventingProperty property) {
        this.skippable = property.isSkippable();
        this.taskListener = Boolean.TRUE.equals(property.isTask()) ? delegateTask -> {
            publisher.publishEvent((Object)delegateTask);
            publisher.publishEvent((Object)new TaskEvent(delegateTask));
        } : null;
        this.executionListener = property.isExecution() ? delegateExecution -> {
            publisher.publishEvent((Object)delegateExecution);
            publisher.publishEvent((Object)new ExecutionEvent(delegateExecution));
        } : null;
    }

    public void parseUserTask(Element userTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addTaskListener(this.taskDefinition(activity));
        this.addExecutionListener(activity);
    }

    public void parseBoundaryEvent(Element boundaryEventElement, ScopeImpl scopeElement, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseCallActivity(Element callActivityElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseEndEvent(Element endEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseEventBasedGateway(Element eventBasedGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseExclusiveGateway(Element exclusiveGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseInclusiveGateway(Element inclusiveGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseIntermediateCatchEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseIntermediateThrowEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseManualTask(Element manualTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseMultiInstanceLoopCharacteristics(Element activityElement, Element multiInstanceLoopCharacteristicsElement, ActivityImpl activity) {
    }

    public void parseParallelGateway(Element parallelGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseProcess(Element processElement, ProcessDefinitionEntity processDefinition) {
        if (this.executionListener != null) {
            for (String event : EXECUTION_EVENTS) {
                this.addListenerOnCoreModelElement((CoreModelElement)processDefinition, (DelegateListener<?>)this.executionListener, event);
            }
        }
    }

    public void parseReceiveTask(Element receiveTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseScriptTask(Element scriptTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseSendTask(Element sendTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseSequenceFlow(Element sequenceFlowElement, ScopeImpl scopeElement, TransitionImpl transition) {
        this.addExecutionListener(transition);
    }

    public void parseServiceTask(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseStartEvent(Element startEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseSubProcess(Element subProcessElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseTask(Element taskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseTransaction(Element transactionElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    private void addExecutionListener(ActivityImpl activity) {
        if (this.executionListener != null) {
            for (String event : EXECUTION_EVENTS) {
                this.addListenerOnCoreModelElement((CoreModelElement)activity, (DelegateListener<?>)this.executionListener, event);
            }
        }
    }

    private void addExecutionListener(TransitionImpl transition) {
        if (this.executionListener != null) {
            this.addListenerOnCoreModelElement((CoreModelElement)transition, (DelegateListener<?>)this.executionListener, "take");
        }
    }

    private void addListenerOnCoreModelElement(CoreModelElement element, DelegateListener<?> listener, String event) {
        if (this.skippable) {
            element.addListener(event, listener);
        } else {
            element.addBuiltInListener(event, listener);
        }
    }

    private void addTaskListener(TaskDefinition taskDefinition) {
        if (this.taskListener != null) {
            for (String event : TASK_EVENTS) {
                if (this.skippable) {
                    taskDefinition.addTaskListener(event, this.taskListener);
                    continue;
                }
                taskDefinition.addBuiltInTaskListener(event, this.taskListener);
            }
        }
    }

    private TaskDefinition taskDefinition(ActivityImpl activity) {
        UserTaskActivityBehavior activityBehavior = (UserTaskActivityBehavior)activity.getActivityBehavior();
        return activityBehavior.getTaskDefinition();
    }
}

