/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.spring.boot.starter.configuration.impl.custom;

import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.filter.Filter;
import org.operaton.bpm.spring.boot.starter.configuration.impl.AbstractOperatonConfiguration;
import org.operaton.bpm.spring.boot.starter.property.FilterProperty;
import org.operaton.bpm.spring.boot.starter.property.OperatonBpmProperties;

public class CreateFilterConfiguration
extends AbstractOperatonConfiguration {
    protected String filterName;

    public CreateFilterConfiguration(OperatonBpmProperties operatonBpmProperties) {
        super(operatonBpmProperties);
    }

    @PostConstruct
    public void init() {
        this.filterName = Optional.ofNullable(this.operatonBpmProperties.getFilter()).map(FilterProperty::getCreate).orElseThrow(CreateFilterConfiguration.fail("filter.create not configured!"));
    }

    @Override
    public void postProcessEngineBuild(ProcessEngine processEngine) {
        Objects.requireNonNull(this.filterName);
        long filterCount = processEngine.getFilterService().createFilterQuery().filterName(this.filterName).count();
        if (filterCount == 0L) {
            Filter filter = processEngine.getFilterService().newTaskFilter(this.filterName);
            processEngine.getFilterService().saveFilter(filter);
            LOG.createInitialFilter(filter);
        } else {
            LOG.skipCreateInitialFilter(this.filterName);
        }
    }

    public String toString() {
        return this.createToString(Collections.singletonMap("filterName", this.filterName));
    }
}

