/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.spring.boot.starter.configuration.impl.custom;

import jakarta.annotation.PostConstruct;
import java.util.Objects;
import java.util.Optional;
import org.operaton.bpm.engine.AuthorizationService;
import org.operaton.bpm.engine.IdentityService;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.authorization.Authorization;
import org.operaton.bpm.engine.authorization.Permission;
import org.operaton.bpm.engine.authorization.Permissions;
import org.operaton.bpm.engine.authorization.Resource;
import org.operaton.bpm.engine.authorization.Resources;
import org.operaton.bpm.engine.identity.Group;
import org.operaton.bpm.engine.identity.User;
import org.operaton.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.operaton.bpm.spring.boot.starter.configuration.impl.AbstractOperatonConfiguration;
import org.operaton.bpm.spring.boot.starter.property.AdminUserProperty;
import org.operaton.bpm.spring.boot.starter.property.OperatonBpmProperties;
import org.springframework.beans.BeanUtils;

public class CreateAdminUserConfiguration
extends AbstractOperatonConfiguration {
    private User adminUser;

    public CreateAdminUserConfiguration(OperatonBpmProperties operatonBpmProperties) {
        super(operatonBpmProperties);
    }

    @PostConstruct
    void init() {
        this.adminUser = Optional.ofNullable(this.operatonBpmProperties.getAdminUser()).map(AdminUserProperty::init).orElseThrow(CreateAdminUserConfiguration.fail("adminUser not configured!"));
    }

    @Override
    public void postProcessEngineBuild(ProcessEngine processEngine) {
        Objects.requireNonNull(this.adminUser, "adminUser not configured!");
        IdentityService identityService = processEngine.getIdentityService();
        AuthorizationService authorizationService = processEngine.getAuthorizationService();
        if (CreateAdminUserConfiguration.userAlreadyExists(identityService, this.adminUser)) {
            return;
        }
        CreateAdminUserConfiguration.createUser(identityService, this.adminUser);
        if (identityService.createGroupQuery().groupId("operaton-admin").count() == 0L) {
            Group operatonAdminGroup = identityService.newGroup("operaton-admin");
            operatonAdminGroup.setName("operaton BPM Administrators");
            operatonAdminGroup.setType("SYSTEM");
            identityService.saveGroup(operatonAdminGroup);
        }
        for (Resources resource : Resources.values()) {
            if (authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"operaton-admin"}).resourceType((Resource)resource).resourceId("*").count() != 0L) continue;
            AuthorizationEntity userAdminAuth = new AuthorizationEntity(1);
            userAdminAuth.setGroupId("operaton-admin");
            userAdminAuth.setResource((Resource)resource);
            userAdminAuth.setResourceId("*");
            userAdminAuth.addPermission((Permission)Permissions.ALL);
            authorizationService.saveAuthorization((Authorization)userAdminAuth);
        }
        identityService.createMembership(this.adminUser.getId(), "operaton-admin");
        LOG.creatingInitialAdminUser(this.adminUser);
    }

    static boolean userAlreadyExists(IdentityService identityService, User adminUser) {
        User existingUser = (User)identityService.createUserQuery().userId(adminUser.getId()).singleResult();
        if (existingUser != null) {
            LOG.skipAdminUserCreation(existingUser);
            return true;
        }
        return false;
    }

    static User createUser(IdentityService identityService, User adminUser) {
        User newUser = identityService.newUser(adminUser.getId());
        BeanUtils.copyProperties((Object)adminUser, (Object)newUser);
        identityService.saveUser(newUser);
        return newUser;
    }
}

