/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.spring.boot.starter.configuration.impl;

import javax.sql.DataSource;
import org.operaton.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.operaton.bpm.spring.boot.starter.configuration.OperatonDatasourceConfiguration;
import org.operaton.bpm.spring.boot.starter.configuration.impl.AbstractOperatonConfiguration;
import org.operaton.bpm.spring.boot.starter.property.DatabaseProperty;
import org.operaton.bpm.spring.boot.starter.property.OperatonBpmProperties;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.StringUtils;

public class DefaultDatasourceConfiguration
extends AbstractOperatonConfiguration
implements OperatonDatasourceConfiguration {
    protected PlatformTransactionManager transactionManager;
    protected PlatformTransactionManager operatonTransactionManager;
    protected DataSource dataSource;
    protected DataSource operatonDataSource;

    public DefaultDatasourceConfiguration(OperatonBpmProperties operatonBpmProperties, PlatformTransactionManager transactionManager, PlatformTransactionManager operatonTransactionManager, DataSource dataSource, DataSource operatonDataSource) {
        super(operatonBpmProperties);
        this.transactionManager = transactionManager;
        this.operatonTransactionManager = operatonTransactionManager;
        this.dataSource = dataSource;
        this.operatonDataSource = operatonDataSource;
    }

    @Override
    public void preInit(SpringProcessEngineConfiguration configuration) {
        DatabaseProperty database = this.operatonBpmProperties.getDatabase();
        if (this.operatonTransactionManager == null) {
            configuration.setTransactionManager(this.transactionManager);
        } else {
            configuration.setTransactionManager(this.operatonTransactionManager);
        }
        if (this.operatonDataSource == null) {
            configuration.setDataSource(this.dataSource);
        } else {
            configuration.setDataSource(this.operatonDataSource);
        }
        configuration.setDatabaseType(database.getType());
        configuration.setDatabaseSchemaUpdate(database.getSchemaUpdate());
        if (StringUtils.hasText((String)database.getTablePrefix())) {
            configuration.setDatabaseTablePrefix(database.getTablePrefix());
        }
        if (StringUtils.hasText((String)database.getSchemaName())) {
            configuration.setDatabaseSchema(database.getSchemaName());
        }
        configuration.setJdbcBatchProcessing(database.isJdbcBatchProcessing());
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public PlatformTransactionManager getOperatonTransactionManager() {
        return this.operatonTransactionManager;
    }

    public void setOperatonTransactionManager(PlatformTransactionManager operatonTransactionManager) {
        this.operatonTransactionManager = operatonTransactionManager;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getOperatonDataSource() {
        return this.operatonDataSource;
    }

    public void setOperatonDataSource(DataSource operatonDataSource) {
        this.operatonDataSource = operatonDataSource;
    }
}

