/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.spring.boot.starter;

import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.spring.ProcessEngineFactoryBean;
import org.operaton.bpm.engine.spring.SpringProcessEngineServicesConfiguration;
import org.operaton.bpm.spring.boot.starter.OperatonBpmActuatorConfiguration;
import org.operaton.bpm.spring.boot.starter.OperatonBpmConfiguration;
import org.operaton.bpm.spring.boot.starter.OperatonBpmPluginConfiguration;
import org.operaton.bpm.spring.boot.starter.OperatonBpmTelemetryConfiguration;
import org.operaton.bpm.spring.boot.starter.event.ProcessApplicationEventPublisher;
import org.operaton.bpm.spring.boot.starter.property.ManagementProperties;
import org.operaton.bpm.spring.boot.starter.property.OperatonBpmProperties;
import org.operaton.bpm.spring.boot.starter.util.OperatonBpmVersion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@EnableConfigurationProperties(value={OperatonBpmProperties.class, ManagementProperties.class})
@Import(value={OperatonBpmConfiguration.class, OperatonBpmActuatorConfiguration.class, OperatonBpmPluginConfiguration.class, OperatonBpmTelemetryConfiguration.class, SpringProcessEngineServicesConfiguration.class})
@Configuration
@ConditionalOnProperty(prefix="operaton.bpm", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={HibernateJpaAutoConfiguration.class})
public class OperatonBpmAutoConfiguration {
    @Bean
    public OperatonBpmVersion operatonBpmVersion() {
        return new OperatonBpmVersion();
    }

    @Bean
    public ProcessApplicationEventPublisher processApplicationEventPublisher(ApplicationEventPublisher publisher) {
        return new ProcessApplicationEventPublisher(publisher);
    }

    @Configuration
    class ProcessEngineConfigurationImplDependingConfiguration {
        protected ProcessEngineConfigurationImpl processEngineConfigurationImpl;

        @Autowired
        public ProcessEngineConfigurationImplDependingConfiguration(ProcessEngineConfigurationImpl processEngineConfigurationImpl) {
            this.processEngineConfigurationImpl = processEngineConfigurationImpl;
        }

        @Bean
        public ProcessEngineFactoryBean processEngineFactoryBean() {
            ProcessEngineFactoryBean factoryBean = new ProcessEngineFactoryBean();
            factoryBean.setProcessEngineConfiguration(this.processEngineConfigurationImpl);
            return factoryBean;
        }

        @Bean
        @Primary
        public CommandExecutor commandExecutorTxRequired() {
            return this.processEngineConfigurationImpl.getCommandExecutorTxRequired();
        }

        @Bean
        public CommandExecutor commandExecutorTxRequiresNew() {
            return this.processEngineConfigurationImpl.getCommandExecutorTxRequiresNew();
        }

        @Bean
        public CommandExecutor commandExecutorSchemaOperations() {
            return this.processEngineConfigurationImpl.getCommandExecutorSchemaOperations();
        }
    }
}

