/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.variable.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import org.operaton.bpm.engine.impl.util.ReflectUtil;
import org.operaton.bpm.engine.impl.variable.serializer.AbstractObjectValueSerializer;
import org.operaton.bpm.engine.variable.Variables;

public class JavaObjectSerializer
extends AbstractObjectValueSerializer {
    public static final String NAME = "serializable";

    public JavaObjectSerializer() {
        super(Variables.SerializationDataFormats.JAVA.getName());
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected boolean isSerializationTextBased() {
        return false;
    }

    @Override
    protected Object deserializeFromByteArray(byte[] bytes, String objectTypeName) throws Exception {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            Object object;
            try (ClassloaderAwareObjectInputStream ois = new ClassloaderAwareObjectInputStream(bais);){
                object = ois.readObject();
            }
            return object;
        }
    }

    @Override
    protected byte[] serializeToByteArray(Object deserializedObject) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream ois = new ObjectOutputStream(baos);){
                ois.writeObject(deserializedObject);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    @Override
    protected String getTypeNameForDeserialized(Object deserializedObject) {
        return deserializedObject.getClass().getName();
    }

    @Override
    protected boolean canSerializeValue(Object value) {
        return value instanceof Serializable;
    }

    protected static class ClassloaderAwareObjectInputStream
    extends ObjectInputStream {
        public ClassloaderAwareObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) {
            return ReflectUtil.loadClass(desc.getName());
        }
    }
}

