/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.util;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.impl.ProcessEngineImpl;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.db.DbEntity;
import org.operaton.bpm.engine.impl.el.ExpressionManager;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public final class StringUtil {
    public static final int DB_MAX_STRING_LENGTH = 666;

    private StringUtil() {
    }

    public static boolean isExpression(String text) {
        return (text = text.trim()).startsWith("${") || text.startsWith("#{");
    }

    public static boolean isCompositeExpression(String text, ExpressionManager expressionManager) {
        return !expressionManager.createExpression(text).isLiteralText();
    }

    public static String[] split(String text, String regex) {
        if (text == null) {
            return new String[0];
        }
        if (regex == null) {
            return new String[]{text};
        }
        String[] result = text.split(regex);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    public static boolean hasAnySuffix(String text, String[] suffixes) {
        for (String suffix : suffixes) {
            if (!text.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static String fromBytes(byte[] bytes) {
        EnsureUtil.ensureActiveCommandContext("StringUtil.fromBytes");
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ProcessEngineImpl processEngine = processEngineConfiguration.getProcessEngine();
        Objects.requireNonNull(processEngine);
        return StringUtil.fromBytes(bytes, processEngine);
    }

    public static String fromBytes(byte[] bytes, ProcessEngine processEngine) {
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        Charset charset = processEngineConfiguration.getDefaultCharset();
        return bytes != null ? new String(bytes, charset) : "";
    }

    public static byte[] toByteArray(String string) {
        EnsureUtil.ensureActiveCommandContext("StringUtil.toByteArray");
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ProcessEngineImpl processEngine = processEngineConfiguration.getProcessEngine();
        Objects.requireNonNull(processEngine);
        return StringUtil.toByteArray(string, processEngine);
    }

    public static byte[] toByteArray(String string, ProcessEngine processEngine) {
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        Charset charset = processEngineConfiguration.getDefaultCharset();
        return string.getBytes(charset);
    }

    public static String trimToMaximumLengthAllowed(String string) {
        if (string != null && string.length() > 666) {
            return string.substring(0, 666);
        }
        return string;
    }

    public static String joinDbEntityIds(Collection<? extends DbEntity> dbEntities) {
        return StringUtil.join(new StringIterator<DbEntity>(dbEntities.iterator()){

            @Override
            public String next() {
                return ((DbEntity)this.iterator.next()).getId();
            }
        });
    }

    public static boolean hasText(String string) {
        return string != null && !string.isEmpty();
    }

    public static String join(Iterator<String> iterator) {
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static abstract class StringIterator<T>
    implements Iterator<String> {
        protected Iterator<? extends T> iterator;

        protected StringIterator(Iterator<? extends T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

