/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.util;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import operatonjar.impl.com.google.gson.Gson;
import operatonjar.impl.com.google.gson.GsonBuilder;
import operatonjar.impl.com.google.gson.JsonArray;
import operatonjar.impl.com.google.gson.JsonElement;
import operatonjar.impl.com.google.gson.JsonIOException;
import operatonjar.impl.com.google.gson.JsonNull;
import operatonjar.impl.com.google.gson.JsonObject;
import operatonjar.impl.com.google.gson.JsonParseException;
import operatonjar.impl.com.google.gson.JsonPrimitive;
import operatonjar.impl.com.google.gson.JsonSyntaxException;
import operatonjar.impl.com.google.gson.internal.LazilyParsedNumber;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.json.JsonObjectConverter;
import org.operaton.bpm.engine.impl.util.EngineUtilLogger;
import org.operaton.bpm.engine.impl.util.StringUtil;

public final class JsonUtil {
    private static final EngineUtilLogger LOG = ProcessEngineLogger.UTIL_LOGGER;
    private static final Gson GSON_MAPPER = JsonUtil.createGsonMapper();

    private JsonUtil() {
    }

    public static void addFieldRawValue(JsonObject jsonObject, String memberName, Object rawValue) {
        if (rawValue != null) {
            JsonElement jsonNode = null;
            try {
                jsonNode = JsonUtil.getGsonMapper().toJsonTree(rawValue);
            }
            catch (JsonIOException e) {
                LOG.logJsonException(e);
            }
            if (jsonNode != null) {
                jsonObject.add(memberName, jsonNode);
            }
        }
    }

    public static <T> void addField(JsonObject jsonObject, String name, JsonObjectConverter<T> converter, T value) {
        if (jsonObject != null && name != null && converter != null && value != null) {
            jsonObject.add(name, converter.toJsonObject(value));
        }
    }

    public static void addListField(JsonObject jsonObject, String name, List<String> list) {
        if (jsonObject != null && name != null && list != null) {
            jsonObject.add(name, JsonUtil.asArray(list));
        }
    }

    public static void addArrayField(JsonObject jsonObject, String name, String[] array) {
        if (jsonObject != null && name != null && array != null) {
            JsonUtil.addListField(jsonObject, name, Arrays.asList(array));
        }
    }

    public static void addDateField(JsonObject jsonObject, String name, Date date) {
        if (jsonObject != null && name != null && date != null) {
            jsonObject.addProperty(name, date.getTime());
        }
    }

    public static <T> void addElement(JsonArray jsonObject, JsonObjectConverter<T> converter, T value) {
        JsonObject jsonElement;
        if (jsonObject != null && converter != null && value != null && (jsonElement = converter.toJsonObject(value)) != null) {
            jsonObject.add(jsonElement);
        }
    }

    public static <T> void addListField(JsonObject jsonObject, String name, JsonObjectConverter<T> converter, List<T> list) {
        if (jsonObject != null && name != null && converter != null && list != null) {
            JsonArray arrayNode = JsonUtil.createArray();
            for (T item : list) {
                JsonObject jsonElement;
                if (item == null || (jsonElement = converter.toJsonObject(item)) == null) continue;
                arrayNode.add(jsonElement);
            }
            jsonObject.add(name, arrayNode);
        }
    }

    public static <T> T asJavaObject(JsonObject jsonObject, JsonObjectConverter<T> converter) {
        if (jsonObject != null && converter != null) {
            return converter.toObject(jsonObject);
        }
        return null;
    }

    public static void addNullField(JsonObject jsonObject, String name) {
        if (jsonObject != null && name != null) {
            jsonObject.add(name, JsonNull.INSTANCE);
        }
    }

    public static void addField(JsonObject jsonObject, String name, JsonArray value) {
        if (jsonObject != null && name != null && value != null) {
            jsonObject.add(name, value);
        }
    }

    public static void addField(JsonObject jsonObject, String name, String value) {
        if (jsonObject != null && name != null && value != null) {
            jsonObject.addProperty(name, value);
        }
    }

    public static void addField(JsonObject jsonObject, String name, Boolean value) {
        if (jsonObject != null && name != null && value != null) {
            jsonObject.addProperty(name, value);
        }
    }

    public static void addField(JsonObject jsonObject, String name, Integer value) {
        if (jsonObject != null && name != null && value != null) {
            jsonObject.addProperty(name, value);
        }
    }

    public static void addField(JsonObject jsonObject, String name, Short value) {
        if (jsonObject != null && name != null && value != null) {
            jsonObject.addProperty(name, value);
        }
    }

    public static void addField(JsonObject jsonObject, String name, Long value) {
        if (jsonObject != null && name != null && value != null) {
            jsonObject.addProperty(name, value);
        }
    }

    public static void addField(JsonObject jsonObject, String name, Double value) {
        if (jsonObject != null && name != null && value != null) {
            jsonObject.addProperty(name, value);
        }
    }

    public static void addDefaultField(JsonObject jsonObject, String name, boolean defaultValue, Boolean value) {
        if (jsonObject != null && name != null && value != null && !value.equals(defaultValue)) {
            JsonUtil.addField(jsonObject, name, value);
        }
    }

    public static byte[] asBytes(JsonElement jsonObject) {
        String jsonString = null;
        if (jsonObject != null) {
            try {
                jsonString = JsonUtil.getGsonMapper().toJson(jsonObject);
            }
            catch (JsonIOException e) {
                LOG.logJsonException(e);
            }
        }
        if (jsonString == null) {
            jsonString = "";
        }
        return StringUtil.toByteArray(jsonString);
    }

    public static JsonObject asObject(byte[] byteArray) {
        String stringValue = null;
        if (byteArray != null) {
            stringValue = StringUtil.fromBytes(byteArray);
        }
        if (stringValue == null) {
            return JsonUtil.createObject();
        }
        JsonObject jsonObject = null;
        try {
            jsonObject = JsonUtil.getGsonMapper().fromJson(stringValue, JsonObject.class);
        }
        catch (JsonParseException e) {
            LOG.logJsonException(e);
        }
        return Objects.requireNonNullElseGet(jsonObject, JsonUtil::createObject);
    }

    public static JsonObject asObject(String jsonString) {
        JsonObject jsonObject = null;
        if (jsonString != null) {
            try {
                jsonObject = JsonUtil.getGsonMapper().fromJson(jsonString, JsonObject.class);
            }
            catch (ClassCastException | JsonParseException e) {
                LOG.logJsonException(e);
            }
        }
        return Objects.requireNonNullElseGet(jsonObject, JsonUtil::createObject);
    }

    public static JsonObject asObject(Map<String, Object> properties) {
        if (properties != null) {
            JsonObject jsonObject = null;
            try {
                jsonObject = (JsonObject)JsonUtil.getGsonMapper().toJsonTree(properties);
            }
            catch (ClassCastException | JsonIOException e) {
                LOG.logJsonException(e);
            }
            return Objects.requireNonNullElseGet(jsonObject, JsonUtil::createObject);
        }
        return JsonUtil.createObject();
    }

    public static List<String> asStringList(JsonElement jsonObject) {
        JsonArray jsonArray = null;
        if (jsonObject != null) {
            try {
                jsonArray = jsonObject.getAsJsonArray();
            }
            catch (ClassCastException | IllegalStateException e) {
                LOG.logJsonException(e);
            }
        }
        if (jsonArray == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (JsonElement entry : jsonArray) {
            String stringValue = null;
            try {
                stringValue = entry.getAsString();
            }
            catch (ClassCastException | IllegalStateException e) {
                LOG.logJsonException(e);
            }
            if (stringValue == null) continue;
            list.add(stringValue);
        }
        return list;
    }

    public static <T, S extends List<T>> S asList(JsonArray jsonArray, JsonObjectConverter<T> converter, Supplier<S> listSupplier) {
        if (jsonArray == null || converter == null) {
            return (S)Collections.emptyList();
        }
        List list = (List)listSupplier.get();
        for (JsonElement element : jsonArray) {
            T rawObject;
            JsonObject jsonObject = null;
            try {
                jsonObject = element.getAsJsonObject();
            }
            catch (ClassCastException | IllegalStateException e) {
                LOG.logJsonException(e);
            }
            if (jsonObject == null || (rawObject = converter.toObject(jsonObject)) == null) continue;
            list.add(rawObject);
        }
        return (S)list;
    }

    public static <T> List<T> asList(JsonArray jsonArray, JsonObjectConverter<T> converter) {
        return JsonUtil.asList(jsonArray, converter, ArrayList::new);
    }

    public static List<Object> asList(JsonElement jsonElement) {
        if (jsonElement == null) {
            return Collections.emptyList();
        }
        JsonArray jsonArray = null;
        try {
            jsonArray = jsonElement.getAsJsonArray();
        }
        catch (ClassCastException | IllegalStateException e) {
            LOG.logJsonException(e);
        }
        if (jsonArray == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonElement entry : jsonArray) {
            if (entry.isJsonPrimitive()) {
                Object rawObject = JsonUtil.asPrimitiveObject((JsonPrimitive)entry);
                if (rawObject == null) continue;
                list.add(rawObject);
                continue;
            }
            if (entry.isJsonNull()) {
                list.add(null);
                continue;
            }
            if (entry.isJsonObject()) {
                list.add(JsonUtil.asMap(entry));
                continue;
            }
            if (!entry.isJsonArray()) continue;
            list.add(JsonUtil.asList(entry));
        }
        return list;
    }

    public static Map<String, Object> asMap(JsonElement jsonElement) {
        if (jsonElement == null) {
            return Collections.emptyMap();
        }
        JsonObject jsonObject = null;
        try {
            jsonObject = jsonElement.getAsJsonObject();
        }
        catch (ClassCastException | IllegalStateException e) {
            LOG.logJsonException(e);
        }
        if (jsonObject == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, JsonElement> jsonEntry : jsonObject.entrySet()) {
            String key = jsonEntry.getKey();
            JsonElement value = jsonEntry.getValue();
            if (value.isJsonPrimitive()) {
                Object rawObject = JsonUtil.asPrimitiveObject((JsonPrimitive)value);
                if (rawObject == null) continue;
                map.put(key, rawObject);
                continue;
            }
            if (value.isJsonNull()) {
                map.put(key, null);
                continue;
            }
            if (value.isJsonObject()) {
                map.put(key, JsonUtil.asMap(value));
                continue;
            }
            if (!value.isJsonArray()) continue;
            map.put(key, JsonUtil.asList(value));
        }
        return map;
    }

    public static String asString(Map<String, Object> properties) {
        JsonObject jsonObject;
        String stringValue = JsonUtil.createObject().toString();
        if (properties != null && (jsonObject = JsonUtil.asObject(properties)) != null) {
            stringValue = jsonObject.toString();
        }
        return stringValue;
    }

    public static String asString(Object data) {
        return GSON_MAPPER.toJson(data);
    }

    public static JsonArray asArray(List<String> list) {
        if (list != null) {
            JsonElement jsonElement = null;
            try {
                jsonElement = JsonUtil.getGsonMapper().toJsonTree(list);
            }
            catch (JsonIOException e) {
                LOG.logJsonException(e);
            }
            if (jsonElement != null) {
                return JsonUtil.getArray(jsonElement);
            }
            return JsonUtil.createArray();
        }
        return JsonUtil.createArray();
    }

    public static Object getRawObject(JsonObject jsonObject, String memberName) {
        if (jsonObject == null || memberName == null) {
            return null;
        }
        Object rawValue = null;
        if (jsonObject.has(memberName)) {
            JsonPrimitive jsonPrimitive = null;
            try {
                jsonPrimitive = jsonObject.getAsJsonPrimitive(memberName);
            }
            catch (ClassCastException e) {
                LOG.logJsonException(e);
            }
            if (jsonPrimitive != null) {
                rawValue = JsonUtil.asPrimitiveObject(jsonPrimitive);
            }
        }
        return rawValue;
    }

    public static Object asPrimitiveObject(JsonPrimitive jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        Object rawObject = null;
        if (jsonValue.isNumber()) {
            Number numberValue = null;
            try {
                numberValue = jsonValue.getAsNumber();
            }
            catch (NumberFormatException e) {
                LOG.logJsonException(e);
            }
            if (numberValue instanceof LazilyParsedNumber) {
                String numberString = numberValue.toString();
                if (numberString != null) {
                    rawObject = JsonUtil.parseNumber(numberString);
                }
            } else {
                rawObject = numberValue;
            }
        } else {
            try {
                rawObject = JsonUtil.getGsonMapper().fromJson((JsonElement)jsonValue, Object.class);
            }
            catch (JsonIOException | JsonSyntaxException e) {
                LOG.logJsonException(e);
            }
        }
        return rawObject;
    }

    private static Number parseNumber(String numberString) {
        if (numberString == null) {
            return null;
        }
        try {
            return Integer.parseInt(numberString);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Long.parseLong(numberString);
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    return Double.parseDouble(numberString);
                }
                catch (NumberFormatException numberFormatException3) {
                    return null;
                }
            }
        }
    }

    public static boolean getBoolean(JsonObject json, String memberName) {
        if (json != null && memberName != null && json.has(memberName)) {
            try {
                return json.get(memberName).getAsBoolean();
            }
            catch (ClassCastException | IllegalStateException e) {
                LOG.logJsonException(e);
                return false;
            }
        }
        return false;
    }

    public static String getString(JsonObject json, String memberName) {
        return JsonUtil.getString(json, memberName, "");
    }

    public static String getString(JsonObject json, String memberName, String defaultString) {
        if (json != null && memberName != null && json.has(memberName)) {
            return JsonUtil.getString(json.get(memberName));
        }
        return defaultString;
    }

    public static String getString(JsonElement jsonElement) {
        if (jsonElement == null) {
            return "";
        }
        try {
            return jsonElement.getAsString();
        }
        catch (ClassCastException | IllegalStateException e) {
            LOG.logJsonException(e);
            return "";
        }
    }

    public static int getInt(JsonObject json, String memberName) {
        if (json != null && memberName != null && json.has(memberName)) {
            try {
                return json.get(memberName).getAsInt();
            }
            catch (ClassCastException | IllegalStateException e) {
                LOG.logJsonException(e);
                return 0;
            }
        }
        return 0;
    }

    public static boolean isNull(JsonObject jsonObject, String memberName) {
        if (jsonObject != null && memberName != null && jsonObject.has(memberName)) {
            return jsonObject.get(memberName).isJsonNull();
        }
        return false;
    }

    public static long getLong(JsonObject json, String memberName) {
        if (json != null && memberName != null && json.has(memberName)) {
            try {
                return json.get(memberName).getAsLong();
            }
            catch (ClassCastException | IllegalStateException e) {
                LOG.logJsonException(e);
                return 0L;
            }
        }
        return 0L;
    }

    public static JsonArray getArray(JsonObject json, String memberName) {
        if (json != null && memberName != null && json.has(memberName)) {
            return JsonUtil.getArray(json.get(memberName));
        }
        return JsonUtil.createArray();
    }

    public static JsonArray getArray(JsonElement json) {
        if (json != null && json.isJsonArray()) {
            return json.getAsJsonArray();
        }
        return JsonUtil.createArray();
    }

    public static JsonObject getObject(JsonObject json, String memberName) {
        if (json != null && memberName != null && json.has(memberName)) {
            return JsonUtil.getObject(json.get(memberName));
        }
        return JsonUtil.createObject();
    }

    public static JsonObject getObject(JsonElement json) {
        if (json != null && json.isJsonObject()) {
            return json.getAsJsonObject();
        }
        return JsonUtil.createObject();
    }

    public static JsonObject createObject() {
        return new JsonObject();
    }

    public static JsonArray createArray() {
        return new JsonArray();
    }

    public static Gson getGsonMapper() {
        return GSON_MAPPER;
    }

    public static Gson createGsonMapper() {
        return new GsonBuilder().serializeNulls().registerTypeAdapter((Type)((Object)Map.class), (json, typeOfT, context) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map.Entry<String, JsonElement> entry : JsonUtil.getObject(json).entrySet()) {
                Object rawValue;
                if (entry == null) continue;
                String key = entry.getKey();
                JsonElement jsonElement = entry.getValue();
                if (jsonElement != null && jsonElement.isJsonNull()) {
                    map.put(key, null);
                    continue;
                }
                if (jsonElement == null || !jsonElement.isJsonPrimitive() || (rawValue = JsonUtil.asPrimitiveObject((JsonPrimitive)jsonElement)) == null) continue;
                map.put(key, rawValue);
            }
            return map;
        }).create();
    }
}

