/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.function.Supplier;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.BatchExecutorException;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.ProcessEnginePersistenceException;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.operaton.bpm.engine.impl.util.StringUtil;
import org.operaton.bpm.engine.repository.ResourceType;

public final class ExceptionUtil {
    public static final String PERSISTENCE_EXCEPTION_MESSAGE = "An exception occurred in the persistence layer. Please check the server logs for a detailed message and the entire exception stack trace.";
    public static final String PERSISTENCE_CONNECTION_ERROR_CLASS = "08";

    private ExceptionUtil() {
    }

    public static String getExceptionStacktrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String getExceptionStacktrace(ByteArrayEntity byteArray) {
        String result = null;
        if (byteArray != null) {
            result = StringUtil.fromBytes(byteArray.getBytes());
        }
        return result;
    }

    public static ByteArrayEntity createJobExceptionByteArray(byte[] byteArray, ResourceType type) {
        return ExceptionUtil.createExceptionByteArray("job.exceptionByteArray", byteArray, type);
    }

    public static ByteArrayEntity createExceptionByteArray(String name, byte[] byteArray, ResourceType type) {
        ByteArrayEntity result = null;
        if (byteArray != null) {
            result = new ByteArrayEntity(name, byteArray, type);
            Context.getCommandContext().getByteArrayManager().insertByteArray(result);
        }
        return result;
    }

    protected static Throwable getPersistenceCauseException(PersistenceException persistenceException) {
        Throwable cause = persistenceException.getCause();
        if (cause instanceof BatchExecutorException) {
            return cause.getCause();
        }
        return persistenceException.getCause();
    }

    public static SQLException unwrapException(PersistenceException persistenceException) {
        Throwable cause = ExceptionUtil.getPersistenceCauseException(persistenceException);
        if (cause instanceof SQLException) {
            SQLException sqlException = (SQLException)cause;
            SQLException nextException = sqlException.getNextException();
            if (nextException != null) {
                return nextException;
            }
            return sqlException;
        }
        return null;
    }

    public static SQLException unwrapException(ProcessEngineException genericPersistenceException) {
        Throwable cause = genericPersistenceException.getCause();
        if (cause instanceof ProcessEngineException) {
            ProcessEngineException processEngineException = (ProcessEngineException)cause;
            Throwable processEngineExceptionCause = processEngineException.getCause();
            if (processEngineExceptionCause instanceof PersistenceException) {
                PersistenceException persistenceException = (PersistenceException)processEngineExceptionCause;
                return ExceptionUtil.unwrapException(persistenceException);
            }
            return null;
        }
        if (cause instanceof PersistenceException) {
            PersistenceException persistenceException = (PersistenceException)cause;
            return ExceptionUtil.unwrapException(persistenceException);
        }
        return null;
    }

    public static boolean checkValueTooLongException(SQLException sqlException) {
        String message = sqlException.getMessage();
        if (message == null) {
            return false;
        }
        message = message.toLowerCase();
        return message.contains("too long") || message.contains("too large") || message.contains("ora-01461") || message.contains("ora-01401") || message.contains("data would be truncated") || message.contains("sqlcode=-302, sqlstate=22001");
    }

    public static boolean checkValueTooLongException(ProcessEngineException genericPersistenceException) {
        SQLException sqlException = ExceptionUtil.unwrapException(genericPersistenceException);
        if (sqlException == null) {
            return false;
        }
        return ExceptionUtil.checkValueTooLongException(sqlException);
    }

    public static boolean checkConstraintViolationException(ProcessEngineException genericPersistenceException) {
        SQLException sqlException = ExceptionUtil.unwrapException(genericPersistenceException);
        if (sqlException == null) {
            return false;
        }
        String message = sqlException.getMessage();
        if (message == null) {
            return false;
        }
        message = message.toLowerCase();
        return message.contains("constraint") || message.contains("violat") || message.contains("duplicate") || message.contains("ora-00001") || message.contains("sqlcode=-803, sqlstate=23505");
    }

    public static boolean checkForeignKeyConstraintViolation(PersistenceException persistenceException) {
        SQLException sqlException = ExceptionUtil.unwrapException(persistenceException);
        if (sqlException == null) {
            return false;
        }
        return ExceptionUtil.checkForeignKeyConstraintViolation(sqlException);
    }

    public static boolean checkForeignKeyConstraintViolation(SQLException sqlException) {
        String message = sqlException.getMessage();
        if (message == null) {
            return false;
        }
        message = message.toLowerCase();
        String sqlState = sqlException.getSQLState();
        int errorCode = sqlException.getErrorCode();
        return message.contains("foreign key constraint") || "23000".equals(sqlState) && errorCode == 547 || "23000".equals(sqlState) && errorCode == 1452 || message.contains("integrity constraint") || "23000".equals(sqlState) && errorCode == 2291 || "23506".equals(sqlState) && errorCode == 23506 || "23503".equals(sqlState) && errorCode == -530 || "23504".equals(sqlState) && errorCode == -532 || "23503".equals(sqlState) && errorCode == 0;
    }

    public static boolean checkVariableIntegrityViolation(PersistenceException persistenceException) {
        SQLException sqlException = ExceptionUtil.unwrapException(persistenceException);
        if (sqlException == null) {
            return false;
        }
        String message = sqlException.getMessage();
        if (message == null) {
            return false;
        }
        message = message.toLowerCase();
        String sqlState = sqlException.getSQLState();
        int errorCode = sqlException.getErrorCode();
        return message.contains("act_uniq_variable") && "23000".equals(sqlState) && errorCode == 1062 || message.contains("act_uniq_variable") && "23505".equals(sqlState) && errorCode == 0 || message.contains("act_uniq_variable") && "23000".equals(sqlState) && errorCode == 2601 || message.contains("act_uniq_variable") && "23000".equals(sqlState) && errorCode == 1 || message.contains("act_uniq_variable") && "23505".equals(sqlState) && errorCode == 23505;
    }

    public static boolean checkDeadlockException(SQLException sqlException) {
        String sqlState = sqlException.getSQLState();
        if (sqlState == null) {
            return false;
        }
        sqlState = sqlState.toUpperCase();
        int errorCode = sqlException.getErrorCode();
        return DEADLOCK_CODES.MARIADB_MYSQL.equals(errorCode, sqlState) || DEADLOCK_CODES.MSSQL.equals(errorCode, sqlState) || DEADLOCK_CODES.DB2.equals(errorCode, sqlState) || DEADLOCK_CODES.ORACLE.equals(errorCode, sqlState) || DEADLOCK_CODES.POSTGRES.equals(errorCode, sqlState) || DEADLOCK_CODES.H2.equals(errorCode, sqlState);
    }

    public static BatchExecutorException findBatchExecutorException(PersistenceException exception) {
        Throwable cause = exception;
        do {
            if (!(cause instanceof BatchExecutorException)) continue;
            BatchExecutorException batchExecutorException = (BatchExecutorException)cause;
            return batchExecutorException;
        } while ((cause = cause.getCause()) != null);
        return null;
    }

    public static <T> T doWithExceptionWrapper(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception ex) {
            throw ExceptionUtil.wrapPersistenceException(ex);
        }
    }

    public static ProcessEnginePersistenceException wrapPersistenceException(Exception ex) {
        return new ProcessEnginePersistenceException(PERSISTENCE_EXCEPTION_MESSAGE, ex);
    }

    public static enum DEADLOCK_CODES {
        MARIADB_MYSQL(1213, "40001"),
        MSSQL(1205, "40001"),
        DB2(-911, "40001"),
        ORACLE(60, "61000"),
        POSTGRES(0, "40P01"),
        H2(40001, "40001");

        protected final int errorCode;
        protected final String sqlState;

        private DEADLOCK_CODES(int errorCode, String sqlState) {
            this.errorCode = errorCode;
            this.sqlState = sqlState;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getSqlState() {
            return this.sqlState;
        }

        protected boolean equals(int errorCode, String sqlState) {
            return this.getErrorCode() == errorCode && this.getSqlState().equals(sqlState);
        }
    }
}

