/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.scripting;

import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.operaton.bpm.engine.ScriptEvaluationException;
import org.operaton.bpm.engine.delegate.BpmnError;
import org.operaton.bpm.engine.delegate.VariableScope;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.scripting.ExecutableScript;
import org.operaton.bpm.engine.impl.scripting.ScriptLogger;

public class CompiledExecutableScript
extends ExecutableScript {
    private static final ScriptLogger LOG = ProcessEngineLogger.SCRIPT_LOGGER;
    protected CompiledScript compiledScript;

    protected CompiledExecutableScript(String language) {
        this(language, null);
    }

    protected CompiledExecutableScript(String language, CompiledScript compiledScript) {
        super(language);
        this.compiledScript = compiledScript;
    }

    public CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    public void setCompiledScript(CompiledScript compiledScript) {
        this.compiledScript = compiledScript;
    }

    @Override
    public Object evaluate(ScriptEngine scriptEngine, VariableScope variableScope, Bindings bindings) {
        try {
            LOG.debugEvaluatingCompiledScript(this.language);
            return this.getCompiledScript().eval(bindings);
        }
        catch (ScriptException e) {
            Throwable cause = e.getCause();
            if (cause instanceof BpmnError) {
                BpmnError bpmnError = (BpmnError)cause;
                throw bpmnError;
            }
            String activityIdMessage = this.getActivityIdExceptionMessage(variableScope);
            throw new ScriptEvaluationException("Unable to evaluate script" + activityIdMessage + ": " + e.getMessage(), e);
        }
    }
}

