/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.pvm;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.operaton.bpm.engine.delegate.ExecutionListener;
import org.operaton.bpm.engine.impl.core.model.CoreModelElement;
import org.operaton.bpm.engine.impl.pvm.PvmException;
import org.operaton.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.pvm.process.ActivityStartBehavior;
import org.operaton.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.operaton.bpm.engine.impl.pvm.process.ScopeImpl;
import org.operaton.bpm.engine.impl.pvm.process.TransitionImpl;

public class ProcessDefinitionBuilder {
    protected ProcessDefinitionImpl processDefinition;
    protected Deque<ScopeImpl> scopeStack = new ArrayDeque<ScopeImpl>();
    protected CoreModelElement processElement = this.processDefinition;
    protected TransitionImpl transition;
    protected List<Object[]> unresolvedTransitions = new ArrayList<Object[]>();

    public ProcessDefinitionBuilder() {
        this(null);
    }

    public ProcessDefinitionBuilder(String processDefinitionId) {
        this.processDefinition = new ProcessDefinitionImpl(processDefinitionId);
        this.scopeStack.push(this.processDefinition);
    }

    public ProcessDefinitionBuilder createActivity(String id) {
        ActivityImpl activity = this.scopeStack.peek().createActivity(id);
        this.scopeStack.push(activity);
        this.processElement = activity;
        this.transition = null;
        return this;
    }

    public ProcessDefinitionBuilder attachedTo(String id, boolean isInterrupting) {
        ActivityImpl activity = this.getActivity();
        activity.setEventScope(this.processDefinition.findActivity(id));
        if (isInterrupting) {
            activity.setActivityStartBehavior(ActivityStartBehavior.INTERRUPT_EVENT_SCOPE);
        } else {
            activity.setActivityStartBehavior(ActivityStartBehavior.CONCURRENT_IN_FLOW_SCOPE);
        }
        return this;
    }

    public ProcessDefinitionBuilder endActivity() {
        this.scopeStack.pop();
        this.processElement = this.scopeStack.peek();
        this.transition = null;
        return this;
    }

    public ProcessDefinitionBuilder initial() {
        this.processDefinition.setInitial(this.getActivity());
        return this;
    }

    public ProcessDefinitionBuilder startTransition(String destinationActivityId) {
        return this.startTransition(destinationActivityId, null);
    }

    public ProcessDefinitionBuilder startTransition(String destinationActivityId, String transitionId) {
        if (destinationActivityId == null) {
            throw new PvmException("destinationActivityId is null");
        }
        ActivityImpl activity = this.getActivity();
        this.transition = activity.createOutgoingTransition(transitionId);
        this.unresolvedTransitions.add(new Object[]{this.transition, destinationActivityId});
        this.processElement = this.transition;
        return this;
    }

    public ProcessDefinitionBuilder endTransition() {
        this.processElement = this.scopeStack.peek();
        this.transition = null;
        return this;
    }

    public ProcessDefinitionBuilder transition(String destinationActivityId) {
        return this.transition(destinationActivityId, null);
    }

    public ProcessDefinitionBuilder transition(String destinationActivityId, String transitionId) {
        this.startTransition(destinationActivityId, transitionId);
        this.endTransition();
        return this;
    }

    public ProcessDefinitionBuilder behavior(ActivityBehavior activityBehaviour) {
        this.getActivity().setActivityBehavior(activityBehaviour);
        return this;
    }

    public ProcessDefinitionBuilder property(String name, Object value) {
        this.processElement.setProperty(name, value);
        return this;
    }

    public PvmProcessDefinition buildProcessDefinition() {
        for (Object[] unresolvedTransition : this.unresolvedTransitions) {
            TransitionImpl trans = (TransitionImpl)unresolvedTransition[0];
            String destinationActivityName = (String)unresolvedTransition[1];
            ActivityImpl destination = this.processDefinition.findActivity(destinationActivityName);
            if (destination == null) {
                throw new RuntimeException("destination '" + destinationActivityName + "' not found.  (referenced from transition in '" + trans.getSource().getId() + "')");
            }
            trans.setDestination(destination);
        }
        return this.processDefinition;
    }

    protected ActivityImpl getActivity() {
        return (ActivityImpl)this.scopeStack.peek();
    }

    public ProcessDefinitionBuilder scope() {
        this.getActivity().setScope(true);
        return this;
    }

    public ProcessDefinitionBuilder executionListener(ExecutionListener executionListener) {
        if (this.transition == null) {
            throw new PvmException("not in a transition scope");
        }
        this.transition.addListener("take", executionListener);
        return this;
    }

    public ProcessDefinitionBuilder executionListener(String eventName, ExecutionListener executionListener) {
        if (this.transition == null) {
            this.scopeStack.peek().addListener(eventName, executionListener);
        } else {
            this.transition.addListener("take", executionListener);
        }
        return this;
    }
}

