/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.operaton.bpm.engine.impl.IncidentQueryImpl;
import org.operaton.bpm.engine.impl.Page;
import org.operaton.bpm.engine.impl.persistence.AbstractManager;
import org.operaton.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.operaton.bpm.engine.runtime.Incident;

public class IncidentManager
extends AbstractManager {
    public List<IncidentEntity> findIncidentsByExecution(String id) {
        return this.getDbEntityManager().selectList("selectIncidentsByExecutionId", id);
    }

    public List<IncidentEntity> findIncidentsByProcessInstance(String id) {
        return this.getDbEntityManager().selectList("selectIncidentsByProcessInstanceId", id);
    }

    public long findIncidentCountByQueryCriteria(IncidentQueryImpl incidentQuery) {
        this.configureQuery(incidentQuery);
        return (Long)this.getDbEntityManager().selectOne("selectIncidentCountByQueryCriteria", incidentQuery);
    }

    public Incident findIncidentById(String id) {
        return this.getDbEntityManager().selectById(IncidentEntity.class, id);
    }

    public List<Incident> findIncidentByConfiguration(String configuration) {
        return this.findIncidentByConfigurationAndIncidentType(configuration, null);
    }

    public List<Incident> findIncidentByConfigurationAndIncidentType(String configuration, String incidentType) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("configuration", configuration);
        params.put("incidentType", incidentType);
        return this.getDbEntityManager().selectList("selectIncidentsByConfiguration", params);
    }

    public List<Incident> findIncidentByQueryCriteria(IncidentQueryImpl incidentQuery, Page page) {
        this.configureQuery(incidentQuery);
        return this.getDbEntityManager().selectList("selectIncidentByQueryCriteria", incidentQuery, page);
    }

    protected void configureQuery(IncidentQueryImpl query) {
        this.getAuthorizationManager().configureIncidentQuery(query);
        this.getTenantManager().configureQuery(query);
    }
}

