/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.history.CleanableHistoricCaseInstanceReportResult;
import org.operaton.bpm.engine.history.HistoricCaseInstance;
import org.operaton.bpm.engine.impl.CleanableHistoricCaseInstanceReportImpl;
import org.operaton.bpm.engine.impl.HistoricCaseInstanceQueryImpl;
import org.operaton.bpm.engine.impl.Page;
import org.operaton.bpm.engine.impl.db.ListQueryParameterObject;
import org.operaton.bpm.engine.impl.history.event.HistoricCaseInstanceEventEntity;
import org.operaton.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.operaton.bpm.engine.impl.persistence.entity.HistoricCaseInstanceEntity;
import org.operaton.bpm.engine.impl.util.ClockUtil;

public class HistoricCaseInstanceManager
extends AbstractHistoricManager {
    public HistoricCaseInstanceEntity findHistoricCaseInstance(String caseInstanceId) {
        if (this.isHistoryEnabled()) {
            return this.getDbEntityManager().selectById(HistoricCaseInstanceEntity.class, caseInstanceId);
        }
        return null;
    }

    public HistoricCaseInstanceEventEntity findHistoricCaseInstanceEvent(String eventId) {
        if (this.isHistoryEnabled()) {
            return this.getDbEntityManager().selectById(HistoricCaseInstanceEventEntity.class, eventId);
        }
        return null;
    }

    public void deleteHistoricCaseInstanceByCaseDefinitionId(String caseDefinitionId) {
        List historicCaseInstanceIds;
        if (this.isHistoryEnabled() && (historicCaseInstanceIds = this.getDbEntityManager().selectList("selectHistoricCaseInstanceIdsByCaseDefinitionId", caseDefinitionId)) != null && !historicCaseInstanceIds.isEmpty()) {
            this.deleteHistoricCaseInstancesByIds(historicCaseInstanceIds);
        }
    }

    public void deleteHistoricCaseInstancesByIds(List<String> historicCaseInstanceIds) {
        if (this.isHistoryEnabled()) {
            this.getHistoricDetailManager().deleteHistoricDetailsByCaseInstanceIds(historicCaseInstanceIds);
            this.getHistoricVariableInstanceManager().deleteHistoricVariableInstancesByCaseInstanceIds(historicCaseInstanceIds);
            this.getHistoricCaseActivityInstanceManager().deleteHistoricCaseActivityInstancesByCaseInstanceIds(historicCaseInstanceIds);
            this.getHistoricTaskInstanceManager().deleteHistoricTaskInstancesByCaseInstanceIds(historicCaseInstanceIds);
            this.getDbEntityManager().delete(HistoricCaseInstanceEntity.class, "deleteHistoricCaseInstancesByIds", historicCaseInstanceIds);
        }
    }

    public long findHistoricCaseInstanceCountByQueryCriteria(HistoricCaseInstanceQueryImpl historicCaseInstanceQuery) {
        if (this.isHistoryEnabled()) {
            this.configureHistoricCaseInstanceQuery(historicCaseInstanceQuery);
            return (Long)this.getDbEntityManager().selectOne("selectHistoricCaseInstanceCountByQueryCriteria", historicCaseInstanceQuery);
        }
        return 0L;
    }

    public List<HistoricCaseInstance> findHistoricCaseInstancesByQueryCriteria(HistoricCaseInstanceQueryImpl historicCaseInstanceQuery, Page page) {
        if (this.isHistoryEnabled()) {
            this.configureHistoricCaseInstanceQuery(historicCaseInstanceQuery);
            return this.getDbEntityManager().selectList("selectHistoricCaseInstancesByQueryCriteria", historicCaseInstanceQuery, page);
        }
        return Collections.emptyList();
    }

    public List<HistoricCaseInstance> findHistoricCaseInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbEntityManager().selectListWithRawParameter("selectHistoricCaseInstanceByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findHistoricCaseInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbEntityManager().selectOne("selectHistoricCaseInstanceCountByNativeQuery", parameterMap);
    }

    protected void configureHistoricCaseInstanceQuery(HistoricCaseInstanceQueryImpl query) {
        this.getTenantManager().configureQuery(query);
    }

    public List<String> findHistoricCaseInstanceIdsForCleanup(int batchSize, int minuteFrom, int minuteTo) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("currentTimestamp", ClockUtil.getCurrentTime());
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        ListQueryParameterObject parameterObject = new ListQueryParameterObject(parameters, 0, batchSize);
        return this.getDbEntityManager().selectList("selectHistoricCaseInstanceIdsForCleanup", parameterObject);
    }

    public List<CleanableHistoricCaseInstanceReportResult> findCleanableHistoricCaseInstancesReportByCriteria(CleanableHistoricCaseInstanceReportImpl query, Page page) {
        query.setCurrentTimestamp(ClockUtil.getCurrentTime());
        this.getTenantManager().configureQuery(query);
        return this.getDbEntityManager().selectList("selectFinishedCaseInstancesReportEntities", query, page);
    }

    public long findCleanableHistoricCaseInstancesReportCountByCriteria(CleanableHistoricCaseInstanceReportImpl query) {
        query.setCurrentTimestamp(ClockUtil.getCurrentTime());
        this.getTenantManager().configureQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectFinishedCaseInstancesReportEntitiesCount", query);
    }
}

