/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.db.DbEntity;
import org.operaton.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.operaton.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.operaton.bpm.engine.impl.repository.ResourceDefinitionEntity;
import org.operaton.bpm.engine.repository.CaseDefinition;
import org.operaton.bpm.engine.repository.DecisionDefinition;
import org.operaton.bpm.engine.repository.DecisionRequirementsDefinition;
import org.operaton.bpm.engine.repository.DeploymentWithDefinitions;
import org.operaton.bpm.engine.repository.ProcessDefinition;

public class DeploymentEntity
implements Serializable,
DeploymentWithDefinitions,
DbEntity {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String name;
    protected Map<String, ResourceEntity> resources;
    protected Date deploymentTime;
    protected boolean validatingSchema = true;
    protected boolean isNew;
    protected String source;
    protected String tenantId;
    protected Map<Class<?>, List> deployedArtifacts;

    public ResourceEntity getResource(String resourceName) {
        return this.getResources().get(resourceName);
    }

    public void addResource(ResourceEntity resource) {
        if (this.resources == null) {
            this.resources = new HashMap<String, ResourceEntity>();
        }
        this.resources.put(resource.getName(), resource);
    }

    public void clearResources() {
        if (this.resources != null) {
            this.resources.clear();
        }
    }

    public Map<String, ResourceEntity> getResources() {
        if (this.resources == null && this.id != null) {
            List<ResourceEntity> resourcesList = Context.getCommandContext().getResourceManager().findResourcesByDeploymentId(this.id);
            this.resources = new HashMap<String, ResourceEntity>();
            for (ResourceEntity resource : resourcesList) {
                this.resources.put(resource.getName(), resource);
            }
        }
        return this.resources;
    }

    @Override
    public Object getPersistentState() {
        return DeploymentEntity.class;
    }

    public void addDeployedArtifact(ResourceDefinitionEntity deployedArtifact) {
        if (this.deployedArtifacts == null) {
            this.deployedArtifacts = new HashMap();
        }
        Class<?> clazz = deployedArtifact.getClass();
        this.deployedArtifacts.computeIfAbsent(clazz, k -> new ArrayList()).add(deployedArtifact);
    }

    public Map<Class<?>, List> getDeployedArtifacts() {
        return this.deployedArtifacts;
    }

    public <T> List<T> getDeployedArtifacts(Class<T> clazz) {
        if (this.deployedArtifacts == null) {
            return null;
        }
        return this.deployedArtifacts.get(clazz);
    }

    public void removeArtifact(ResourceDefinitionEntity notDeployedArtifact) {
        List artifacts;
        if (this.deployedArtifacts != null && (artifacts = this.deployedArtifacts.get(notDeployedArtifact.getClass())) != null) {
            artifacts.remove(notDeployedArtifact);
            if (artifacts.isEmpty()) {
                this.deployedArtifacts.remove(notDeployedArtifact.getClass());
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setResources(Map<String, ResourceEntity> resources) {
        this.resources = resources;
    }

    @Override
    public Date getDeploymentTime() {
        return this.deploymentTime;
    }

    public void setDeploymentTime(Date deploymentTime) {
        this.deploymentTime = deploymentTime;
    }

    public boolean isValidatingSchema() {
        return this.validatingSchema;
    }

    public void setValidatingSchema(boolean validatingSchema) {
        this.validatingSchema = validatingSchema;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public List<ProcessDefinition> getDeployedProcessDefinitions() {
        return this.deployedArtifacts == null ? null : this.deployedArtifacts.get(ProcessDefinitionEntity.class);
    }

    @Override
    public List<CaseDefinition> getDeployedCaseDefinitions() {
        return this.deployedArtifacts == null ? null : this.deployedArtifacts.get(CaseDefinitionEntity.class);
    }

    @Override
    public List<DecisionDefinition> getDeployedDecisionDefinitions() {
        return this.deployedArtifacts == null ? null : this.deployedArtifacts.get(DecisionDefinitionEntity.class);
    }

    @Override
    public List<DecisionRequirementsDefinition> getDeployedDecisionRequirementsDefinitions() {
        return this.deployedArtifacts == null ? null : this.deployedArtifacts.get(DecisionRequirementsDefinitionEntity.class);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", name=" + this.name + ", resources=" + String.valueOf(this.resources) + ", deploymentTime=" + String.valueOf(this.deploymentTime) + ", validatingSchema=" + this.validatingSchema + ", isNew=" + this.isNew + ", source=" + this.source + ", tenantId=" + this.tenantId + "]";
    }
}

