/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.persistence.deploy.cache;

import java.util.Collections;
import java.util.List;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.persistence.deploy.Deployer;
import org.operaton.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ResourceEntity;

public class CacheDeployer {
    protected List<Deployer> deployers = Collections.emptyList();

    public void setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
    }

    public void deploy(DeploymentEntity deployment) {
        Context.getCommandContext().runWithoutAuthorization(() -> {
            for (Deployer deployer : this.deployers) {
                deployer.deploy(deployment);
            }
            return null;
        });
    }

    public void deployOnlyGivenResourcesOfDeployment(DeploymentEntity deployment, String ... resourceNames) {
        this.initDeployment(deployment, resourceNames);
        Context.getCommandContext().runWithoutAuthorization(() -> {
            for (Deployer deployer : this.deployers) {
                deployer.deploy(deployment);
            }
            return null;
        });
        deployment.setResources(null);
    }

    protected void initDeployment(DeploymentEntity deployment, String ... resourceNames) {
        deployment.clearResources();
        for (String resourceName : resourceNames) {
            if (resourceName == null) continue;
            ResourceEntity resource = Context.getCommandContext().getResourceManager().findResourceByDeploymentIdAndResourceName(deployment.getId(), resourceName);
            deployment.addResource(resource);
        }
    }
}

