/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.migration.instance;

import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.history.HistoryLevel;
import org.operaton.bpm.engine.impl.history.event.HistoryEvent;
import org.operaton.bpm.engine.impl.history.event.HistoryEventProcessor;
import org.operaton.bpm.engine.impl.history.event.HistoryEventTypes;
import org.operaton.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.operaton.bpm.engine.impl.migration.instance.MigratingInstance;
import org.operaton.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import org.operaton.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.operaton.bpm.engine.impl.pvm.process.ScopeImpl;

public class MigratingVariableInstance
implements MigratingInstance {
    protected VariableInstanceEntity variable;
    protected boolean isConcurrentLocalInParentScope;

    public MigratingVariableInstance(VariableInstanceEntity variable, boolean isConcurrentLocalInParentScope) {
        this.variable = variable;
        this.isConcurrentLocalInParentScope = isConcurrentLocalInParentScope;
    }

    @Override
    public boolean isDetached() {
        return this.variable.getExecutionId() == null;
    }

    @Override
    public void detachState() {
        this.variable.getExecution().removeVariableInternal(this.variable);
    }

    @Override
    public void attachState(MigratingScopeInstance owningActivityInstance) {
        ExecutionEntity representativeExecution = owningActivityInstance.resolveRepresentativeExecution();
        ScopeImpl currentScope = owningActivityInstance.getCurrentScope();
        ExecutionEntity newOwningExecution = representativeExecution;
        if (currentScope.isScope() && this.isConcurrentLocalInParentScope) {
            newOwningExecution = representativeExecution.getParent();
        }
        newOwningExecution.addVariableInternal(this.variable);
    }

    @Override
    public void attachState(MigratingTransitionInstance owningActivityInstance) {
        ExecutionEntity representativeExecution = owningActivityInstance.resolveRepresentativeExecution();
        representativeExecution.addVariableInternal(this.variable);
    }

    @Override
    public void migrateState() {
        this.migrateHistory();
    }

    protected void migrateHistory() {
        HistoryLevel historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.VARIABLE_INSTANCE_MIGRATE, this)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createHistoricVariableMigrateEvt(MigratingVariableInstance.this.variable);
                }
            });
        }
    }

    @Override
    public void migrateDependentEntities() {
    }

    public String getVariableName() {
        return this.variable.getName();
    }
}

