/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.migration.instance;

import java.util.ArrayList;
import java.util.List;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.migration.MigrationLogger;
import org.operaton.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.operaton.bpm.engine.impl.migration.instance.MigratingAsyncJobInstance;
import org.operaton.bpm.engine.impl.migration.instance.MigratingInstance;
import org.operaton.bpm.engine.impl.migration.instance.MigratingJobInstance;
import org.operaton.bpm.engine.impl.migration.instance.MigratingProcessElementInstance;
import org.operaton.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.pvm.PvmActivity;
import org.operaton.bpm.engine.impl.pvm.process.ScopeImpl;
import org.operaton.bpm.engine.migration.MigrationInstruction;
import org.operaton.bpm.engine.runtime.TransitionInstance;

public class MigratingTransitionInstance
extends MigratingProcessElementInstance
implements MigratingInstance {
    public static final MigrationLogger MIGRATION_LOGGER = ProcessEngineLogger.MIGRATION_LOGGER;
    protected ExecutionEntity representativeExecution;
    protected TransitionInstance transitionInstance;
    protected MigratingAsyncJobInstance jobInstance;
    protected List<MigratingInstance> migratingDependentInstances = new ArrayList<MigratingInstance>();
    protected boolean activeState;

    public MigratingTransitionInstance(TransitionInstance transitionInstance, MigrationInstruction migrationInstruction, ScopeImpl sourceScope, ScopeImpl targetScope, ExecutionEntity asyncExecution) {
        this.transitionInstance = transitionInstance;
        this.migrationInstruction = migrationInstruction;
        this.sourceScope = sourceScope;
        this.targetScope = targetScope;
        this.currentScope = sourceScope;
        this.representativeExecution = asyncExecution;
        this.activeState = this.representativeExecution.isActive();
    }

    @Override
    public boolean isDetached() {
        return this.jobInstance.isDetached();
    }

    @Override
    public MigratingActivityInstance getParent() {
        return (MigratingActivityInstance)super.getParent();
    }

    @Override
    public void detachState() {
        this.jobInstance.detachState();
        for (MigratingInstance dependentInstance : this.migratingDependentInstances) {
            dependentInstance.detachState();
        }
        ExecutionEntity execution = this.resolveRepresentativeExecution();
        execution.setActive(false);
        this.getParent().destroyAttachableExecution(execution);
        this.setParent(null);
    }

    @Override
    public void attachState(MigratingScopeInstance scopeInstance) {
        if (!(scopeInstance instanceof MigratingActivityInstance)) {
            throw MIGRATION_LOGGER.cannotHandleChild(scopeInstance, this);
        }
        MigratingActivityInstance activityInstance = (MigratingActivityInstance)scopeInstance;
        this.setParent(activityInstance);
        this.representativeExecution = activityInstance.createAttachableExecution();
        this.representativeExecution.setActivityInstanceId(null);
        this.representativeExecution.setActive(this.activeState);
        this.jobInstance.attachState(this);
        for (MigratingInstance dependentInstance : this.migratingDependentInstances) {
            dependentInstance.attachState(this);
        }
    }

    @Override
    public ExecutionEntity resolveRepresentativeExecution() {
        if (this.representativeExecution.getReplacedBy() != null) {
            return this.representativeExecution.resolveReplacedBy();
        }
        return this.representativeExecution;
    }

    @Override
    public void attachState(MigratingTransitionInstance targetTransitionInstance) {
        throw MIGRATION_LOGGER.cannotAttachToTransitionInstance(this);
    }

    public void setDependentJobInstance(MigratingAsyncJobInstance jobInstance) {
        this.jobInstance = jobInstance;
    }

    @Override
    public void addMigratingDependentInstance(MigratingInstance migratingInstance) {
        this.migratingDependentInstances.add(migratingInstance);
    }

    public List<MigratingInstance> getMigratingDependentInstances() {
        return this.migratingDependentInstances;
    }

    @Override
    public void migrateState() {
        ExecutionEntity representativeExec = this.resolveRepresentativeExecution();
        representativeExec.setProcessDefinition(this.targetScope.getProcessDefinition());
        representativeExec.setActivity((PvmActivity)((Object)this.targetScope));
    }

    @Override
    public void migrateDependentEntities() {
        this.jobInstance.migrateState();
        this.jobInstance.migrateDependentEntities();
        for (MigratingInstance dependentInstance : this.migratingDependentInstances) {
            dependentInstance.migrateState();
            dependentInstance.migrateDependentEntities();
        }
    }

    public TransitionInstance getTransitionInstance() {
        return this.transitionInstance;
    }

    public boolean isAsyncAfter() {
        return this.jobInstance.isAsyncAfter();
    }

    public boolean isAsyncBefore() {
        return this.jobInstance.isAsyncBefore();
    }

    public MigratingJobInstance getJobInstance() {
        return this.jobInstance;
    }

    @Override
    public void setParent(MigratingScopeInstance parentInstance) {
        if (parentInstance != null && !(parentInstance instanceof MigratingActivityInstance)) {
            throw MIGRATION_LOGGER.cannotHandleChild(parentInstance, this);
        }
        MigratingActivityInstance parentActivityInstance = (MigratingActivityInstance)parentInstance;
        if (this.parentInstance != null) {
            ((MigratingActivityInstance)this.parentInstance).removeChild(this);
        }
        this.parentInstance = parentActivityInstance;
        if (parentInstance != null) {
            parentActivityInstance.addChild(this);
        }
    }
}

