/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.jobexecutor.historycleanup;

import java.util.HashMap;
import java.util.Map;
import org.operaton.bpm.engine.impl.batch.history.HistoricBatchEntity;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.db.DbEntity;
import org.operaton.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.operaton.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import org.operaton.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHandler;
import org.operaton.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.operaton.bpm.engine.impl.persistence.entity.TaskMeterLogEntity;
import org.operaton.bpm.engine.impl.util.ClockUtil;

public class HistoryCleanupRemovalTime
extends HistoryCleanupHandler {
    protected Map<Class<? extends DbEntity>, DbOperation> deleteOperations = new HashMap<Class<? extends DbEntity>, DbOperation>();

    @Override
    public void performCleanup() {
        this.deleteOperations.putAll(this.performProcessCleanup());
        if (this.isDmnEnabled()) {
            this.deleteOperations.putAll(this.performDmnCleanup());
        }
        DbOperation batchCleanup = this.performBatchCleanup();
        this.deleteOperations.put(batchCleanup.getEntityType(), batchCleanup);
        if (this.getTaskMetricsTimeToLive() != null) {
            DbOperation taskMetricsCleanup = this.performTaskMetricsCleanup();
            this.deleteOperations.put(taskMetricsCleanup.getEntityType(), taskMetricsCleanup);
        }
    }

    protected Map<Class<? extends DbEntity>, DbOperation> performDmnCleanup() {
        return Context.getCommandContext().getHistoricDecisionInstanceManager().deleteHistoricDecisionsByRemovalTime(ClockUtil.getCurrentTime(), this.configuration.getMinuteFrom(), this.configuration.getMinuteTo(), this.getBatchSize());
    }

    protected Map<Class<? extends DbEntity>, DbOperation> performProcessCleanup() {
        return Context.getCommandContext().getHistoricProcessInstanceManager().deleteHistoricProcessInstancesByRemovalTime(ClockUtil.getCurrentTime(), this.configuration.getMinuteFrom(), this.configuration.getMinuteTo(), this.getBatchSize());
    }

    protected DbOperation performBatchCleanup() {
        return Context.getCommandContext().getHistoricBatchManager().deleteHistoricBatchesByRemovalTime(ClockUtil.getCurrentTime(), this.configuration.getMinuteFrom(), this.configuration.getMinuteTo(), this.getBatchSize());
    }

    protected DbOperation performTaskMetricsCleanup() {
        return Context.getCommandContext().getMeterLogManager().deleteTaskMetricsByRemovalTime(ClockUtil.getCurrentTime(), this.getTaskMetricsTimeToLive(), this.configuration.getMinuteFrom(), this.configuration.getMinuteTo(), this.getBatchSize());
    }

    @Override
    protected Map<String, Long> reportMetrics() {
        DbOperation deleteOperationTaskMetric;
        DbOperation deleteOperationBatch;
        DbOperation deleteOperationDecisionInstance;
        HashMap<String, Long> reports = new HashMap<String, Long>();
        DbOperation deleteOperationProcessInstance = this.deleteOperations.get(HistoricProcessInstanceEntity.class);
        if (deleteOperationProcessInstance != null) {
            reports.put("history-cleanup-removed-process-instances", Long.valueOf(deleteOperationProcessInstance.getRowsAffected()));
        }
        if ((deleteOperationDecisionInstance = this.deleteOperations.get(HistoricDecisionInstanceEntity.class)) != null) {
            reports.put("history-cleanup-removed-decision-instances", Long.valueOf(deleteOperationDecisionInstance.getRowsAffected()));
        }
        if ((deleteOperationBatch = this.deleteOperations.get(HistoricBatchEntity.class)) != null) {
            reports.put("history-cleanup-removed-batch-operations", Long.valueOf(deleteOperationBatch.getRowsAffected()));
        }
        if ((deleteOperationTaskMetric = this.deleteOperations.get(TaskMeterLogEntity.class)) != null) {
            reports.put("history-cleanup-removed-task-metrics", Long.valueOf(deleteOperationTaskMetric.getRowsAffected()));
        }
        return reports;
    }

    protected boolean isDmnEnabled() {
        return Context.getProcessEngineConfiguration().isDmnEnabled();
    }

    protected Integer getTaskMetricsTimeToLive() {
        return Context.getProcessEngineConfiguration().getParsedTaskMetricsTimeToLive();
    }

    @Override
    protected boolean shouldRescheduleNow() {
        int batchSize = this.getBatchSize();
        for (DbOperation deleteOperation : this.deleteOperations.values()) {
            if (deleteOperation.getRowsAffected() != batchSize) continue;
            return true;
        }
        return false;
    }

    public int getBatchSize() {
        return Context.getProcessEngineConfiguration().getHistoryCleanupBatchSize();
    }
}

