/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.identity;

import java.util.HashMap;
import java.util.Map;
import org.operaton.bpm.engine.identity.PasswordPolicyRule;

public class PasswordPolicyUpperCaseRuleImpl
implements PasswordPolicyRule {
    public static final String PLACEHOLDER = "PASSWORD_POLICY_UPPERCASE";
    protected int minUpperCase;

    public PasswordPolicyUpperCaseRuleImpl(int minUpperCase) {
        this.minUpperCase = minUpperCase;
    }

    @Override
    public String getPlaceholder() {
        return PLACEHOLDER;
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("minUpperCase", "" + this.minUpperCase);
        return parameter;
    }

    @Override
    public boolean execute(String password) {
        int upperCaseCount = 0;
        char[] cArray = password.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (Character.isUpperCase(c.charValue())) {
                ++upperCaseCount;
            }
            if (upperCaseCount < this.minUpperCase) continue;
            return true;
        }
        return false;
    }
}

