/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.form.entity;

import java.util.HashMap;
import java.util.List;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.db.EnginePersistenceLogger;
import org.operaton.bpm.engine.impl.db.ListQueryParameterObject;
import org.operaton.bpm.engine.impl.persistence.AbstractManager;
import org.operaton.bpm.engine.impl.persistence.AbstractResourceDefinitionManager;
import org.operaton.bpm.engine.impl.persistence.entity.OperatonFormDefinitionEntity;

public class OperatonFormDefinitionManager
extends AbstractManager
implements AbstractResourceDefinitionManager<OperatonFormDefinitionEntity> {
    private static final String OPERATON_FORM_DEFINITION_KEY = "operatonFormDefinitionKey";
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;

    @Override
    public OperatonFormDefinitionEntity findLatestDefinitionByKey(String key) {
        List operatonFormDefinitions = this.getDbEntityManager().selectList("selectLatestOperatonFormDefinitionByKey", this.configureParameterizedQuery(key));
        if (operatonFormDefinitions.isEmpty()) {
            return null;
        }
        if (operatonFormDefinitions.size() == 1) {
            return (OperatonFormDefinitionEntity)operatonFormDefinitions.iterator().next();
        }
        throw LOG.multipleTenantsForOperatonFormDefinitionKeyException(key);
    }

    @Override
    public OperatonFormDefinitionEntity findLatestDefinitionById(String id) {
        return this.getDbEntityManager().selectById(OperatonFormDefinitionEntity.class, id);
    }

    @Override
    public OperatonFormDefinitionEntity findLatestDefinitionByKeyAndTenantId(String definitionKey, String tenantId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(OPERATON_FORM_DEFINITION_KEY, definitionKey);
        parameters.put("tenantId", tenantId);
        if (tenantId == null) {
            return (OperatonFormDefinitionEntity)this.getDbEntityManager().selectOne("selectLatestOperatonFormDefinitionByKeyWithoutTenantId", parameters);
        }
        return (OperatonFormDefinitionEntity)this.getDbEntityManager().selectOne("selectLatestOperatonDefinitionByKeyAndTenantId", parameters);
    }

    @Override
    public OperatonFormDefinitionEntity findDefinitionByKeyVersionAndTenantId(String definitionKey, Integer definitionVersion, String tenantId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("operatonFormDefinitionVersion", definitionVersion);
        parameters.put(OPERATON_FORM_DEFINITION_KEY, definitionKey);
        parameters.put("tenantId", tenantId);
        if (tenantId == null) {
            return (OperatonFormDefinitionEntity)this.getDbEntityManager().selectOne("selectOperatonFormDefinitionByKeyVersionWithoutTenantId", parameters);
        }
        return (OperatonFormDefinitionEntity)this.getDbEntityManager().selectOne("selectOperatonFormDefinitionByKeyVersionAndTenantId", parameters);
    }

    @Override
    public OperatonFormDefinitionEntity findDefinitionByDeploymentAndKey(String deploymentId, String definitionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put(OPERATON_FORM_DEFINITION_KEY, definitionKey);
        return (OperatonFormDefinitionEntity)this.getDbEntityManager().selectOne("selectOperatonFormDefinitionByDeploymentAndKey", parameters);
    }

    public List<OperatonFormDefinitionEntity> findDefinitionsByDeploymentId(String deploymentId) {
        return this.getDbEntityManager().selectList("selectOperatonFormDefinitionByDeploymentId", deploymentId);
    }

    @Override
    public OperatonFormDefinitionEntity getCachedResourceDefinitionEntity(String definitionId) {
        return this.getDbEntityManager().getCachedEntity(OperatonFormDefinitionEntity.class, definitionId);
    }

    @Override
    public OperatonFormDefinitionEntity findDefinitionByKeyVersionTagAndTenantId(String definitionKey, String definitionVersionTag, String tenantId) {
        throw new UnsupportedOperationException("Currently finding Operaton Form definition by version tag and tenant is not implemented.");
    }

    public void deleteOperatonFormDefinitionsByDeploymentId(String deploymentId) {
        this.getDbEntityManager().delete(OperatonFormDefinitionEntity.class, "deleteOperatonFormDefinitionsByDeploymentId", deploymentId);
    }

    protected ListQueryParameterObject configureParameterizedQuery(Object parameter) {
        return this.getTenantManager().configureQuery(parameter);
    }
}

