/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.core.variable.scope;

import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.core.variable.event.VariableEvent;
import org.operaton.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.operaton.bpm.engine.impl.core.variable.scope.VariableInstanceLifecycleListener;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.TaskEntity;
import org.operaton.bpm.engine.impl.persistence.entity.VariableInstanceEntity;

public class VariableListenerInvocationListener
implements VariableInstanceLifecycleListener<VariableInstanceEntity> {
    protected final AbstractVariableScope targetScope;

    public VariableListenerInvocationListener(AbstractVariableScope targetScope) {
        this.targetScope = targetScope;
    }

    @Override
    public void onCreate(VariableInstanceEntity variable, AbstractVariableScope sourceScope) {
        this.handleEvent(new VariableEvent(variable, "create", sourceScope));
    }

    @Override
    public void onUpdate(VariableInstanceEntity variable, AbstractVariableScope sourceScope) {
        this.handleEvent(new VariableEvent(variable, "update", sourceScope));
    }

    @Override
    public void onDelete(VariableInstanceEntity variable, AbstractVariableScope sourceScope) {
        this.handleEvent(new VariableEvent(variable, "delete", sourceScope));
    }

    protected void handleEvent(VariableEvent event) {
        AbstractVariableScope sourceScope = event.getSourceScope();
        if (sourceScope instanceof ExecutionEntity) {
            ExecutionEntity executionEntity = (ExecutionEntity)sourceScope;
            this.addEventToScopeExecution(executionEntity, event);
        } else if (sourceScope instanceof TaskEntity) {
            TaskEntity task = (TaskEntity)sourceScope;
            ExecutionEntity execution = task.getExecution();
            if (execution != null) {
                this.addEventToScopeExecution(execution, event);
            }
        } else {
            AbstractVariableScope abstractVariableScope = sourceScope.getParentVariableScope();
            if (abstractVariableScope instanceof ExecutionEntity) {
                ExecutionEntity executionEntity = (ExecutionEntity)abstractVariableScope;
                this.addEventToScopeExecution(executionEntity, event);
            } else {
                throw new ProcessEngineException("BPMN execution scope expected");
            }
        }
    }

    protected void addEventToScopeExecution(ExecutionEntity sourceScope, VariableEvent event) {
        ExecutionEntity sourceExecution = sourceScope;
        ExecutionEntity scopeExecution = sourceExecution.isScope() ? sourceExecution : sourceExecution.getParent();
        scopeExecution.delayEvent((ExecutionEntity)this.targetScope, event);
    }
}

