/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.context;

import java.util.concurrent.Callable;
import org.operaton.bpm.engine.impl.util.ClassLoaderUtil;

public class ProcessApplicationClassloaderInterceptor<T>
implements Callable<T> {
    private static final ThreadLocal<ClassLoader> PA_CLASSLOADER = new ThreadLocal();
    protected Callable<T> delegate;

    public ProcessApplicationClassloaderInterceptor(Callable<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T call() throws Exception {
        try {
            PA_CLASSLOADER.set(ClassLoaderUtil.getContextClassloader());
            T t = this.delegate.call();
            return t;
        }
        finally {
            PA_CLASSLOADER.remove();
        }
    }

    public static ClassLoader getProcessApplicationClassLoader() {
        return PA_CLASSLOADER.get();
    }
}

