/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.impl.HistoryTimeToLiveParser;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class UpdateDecisionDefinitionHistoryTimeToLiveCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String decisionDefinitionId;
    protected Integer historyTimeToLive;

    public UpdateDecisionDefinitionHistoryTimeToLiveCmd(String decisionDefinitionId, Integer historyTimeToLive) {
        this.decisionDefinitionId = decisionDefinitionId;
        this.historyTimeToLive = historyTimeToLive;
    }

    @Override
    public Void execute(CommandContext context) {
        this.checkAuthorization(context);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "decisionDefinitionId", (Object)this.decisionDefinitionId);
        if (this.historyTimeToLive != null) {
            EnsureUtil.ensureGreaterThanOrEqual(BadUserRequestException.class, "", "historyTimeToLive", this.historyTimeToLive.intValue(), 0L);
        }
        this.validate(this.historyTimeToLive, context);
        DecisionDefinitionEntity decisionDefinitionEntity = context.getDecisionDefinitionManager().findDecisionDefinitionById(this.decisionDefinitionId);
        this.logUserOperation(context, decisionDefinitionEntity);
        decisionDefinitionEntity.setHistoryTimeToLive(this.historyTimeToLive);
        return null;
    }

    protected void checkAuthorization(CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateDecisionDefinitionById(this.decisionDefinitionId);
        }
    }

    protected void logUserOperation(CommandContext commandContext, DecisionDefinitionEntity decisionDefinitionEntity) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("historyTimeToLive", decisionDefinitionEntity.getHistoryTimeToLive(), this.historyTimeToLive));
        propertyChanges.add(new PropertyChange("decisionDefinitionId", null, this.decisionDefinitionId));
        propertyChanges.add(new PropertyChange("decisionDefinitionKey", null, decisionDefinitionEntity.getKey()));
        commandContext.getOperationLogManager().logDecisionDefinitionOperation("UpdateHistoryTimeToLive", decisionDefinitionEntity.getTenantId(), propertyChanges);
    }

    protected void validate(Integer historyTimeToLive, CommandContext context) {
        HistoryTimeToLiveParser parser = HistoryTimeToLiveParser.create(context);
        parser.validate(historyTimeToLive);
    }
}

