/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.util.Collections;
import java.util.Set;
import org.operaton.bpm.application.ProcessApplicationReference;
import org.operaton.bpm.application.ProcessApplicationRegistration;
import org.operaton.bpm.engine.impl.application.ProcessApplicationManager;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;

public class RegisterProcessApplicationCmd
implements Command<ProcessApplicationRegistration> {
    protected ProcessApplicationReference reference;
    protected Set<String> deploymentsToRegister;

    public RegisterProcessApplicationCmd(String deploymentId, ProcessApplicationReference reference) {
        this(Collections.singleton(deploymentId), reference);
    }

    public RegisterProcessApplicationCmd(Set<String> deploymentsToRegister, ProcessApplicationReference appReference) {
        this.deploymentsToRegister = deploymentsToRegister;
        this.reference = appReference;
    }

    @Override
    public ProcessApplicationRegistration execute(CommandContext commandContext) {
        commandContext.getAuthorizationManager().checkOperatonAdminOrPermission(CommandChecker::checkRegisterProcessApplication);
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ProcessApplicationManager processApplicationManager = processEngineConfiguration.getProcessApplicationManager();
        return processApplicationManager.registerProcessApplicationForDeployments(this.deploymentsToRegister, this.reference);
    }
}

