/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.delegate.Expression;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.form.FormDefinition;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.operaton.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.operaton.bpm.engine.impl.task.TaskDefinition;

public class GetFormKeyCmd
implements Command<String> {
    protected String taskDefinitionKey;
    protected String processDefinitionId;

    public GetFormKeyCmd(String processDefinitionId) {
        this.setProcessDefinitionId(processDefinitionId);
    }

    public GetFormKeyCmd(String processDefinitionId, String taskDefinitionKey) {
        this.setProcessDefinitionId(processDefinitionId);
        if (taskDefinitionKey == null || taskDefinitionKey.isEmpty()) {
            throw new ProcessEngineException("The task definition key is mandatory, but '" + taskDefinitionKey + "' has been provided.");
        }
        this.taskDefinitionKey = taskDefinitionKey;
    }

    protected void setProcessDefinitionId(String processDefinitionId) {
        if (processDefinitionId == null || processDefinitionId.isEmpty()) {
            throw new ProcessEngineException("The process definition id is mandatory, but '" + processDefinitionId + "' has been provided.");
        }
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        DeploymentCache deploymentCache = processEngineConfiguration.getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(this.processDefinitionId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadProcessDefinition(processDefinition);
        }
        Expression formKeyExpression = null;
        if (this.taskDefinitionKey == null) {
            FormDefinition formDefinition = processDefinition.getStartFormDefinition();
            formKeyExpression = formDefinition.getFormKey();
        } else {
            TaskDefinition taskDefinition = processDefinition.getTaskDefinitions().get(this.taskDefinitionKey);
            formKeyExpression = taskDefinition.getFormKey();
        }
        String formKey = null;
        if (formKeyExpression != null) {
            formKey = formKeyExpression.getExpressionText();
        }
        return formKey;
    }
}

