/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.IdentityInfoEntity;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class DeleteUserPictureCmd
implements Command<Void> {
    protected String userId;

    public DeleteUserPictureCmd(String userId) {
        this.userId = userId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("UserId", (Object)this.userId);
        IdentityInfoEntity infoEntity = commandContext.getIdentityInfoManager().findUserInfoByUserIdAndKey(this.userId, "picture");
        if (infoEntity != null) {
            String byteArrayId = infoEntity.getValue();
            if (byteArrayId != null) {
                commandContext.getByteArrayManager().deleteByteArrayById(byteArrayId);
            }
            commandContext.getIdentityInfoManager().delete(infoEntity);
        }
        return null;
    }
}

