/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.TaskEntity;
import org.operaton.bpm.engine.impl.persistence.entity.TaskManager;

public class DeleteTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected Collection<String> taskIds;
    protected boolean cascade;
    protected String deleteReason;

    public DeleteTaskCmd(String taskId, String deleteReason, boolean cascade) {
        this.taskId = taskId;
        this.cascade = cascade;
        this.deleteReason = deleteReason;
    }

    public DeleteTaskCmd(Collection<String> taskIds, String deleteReason, boolean cascade) {
        this.taskIds = taskIds;
        this.cascade = cascade;
        this.deleteReason = deleteReason;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.taskId != null) {
            this.deleteTask(this.taskId, commandContext);
        } else if (this.taskIds != null) {
            this.taskIds.forEach(id -> this.deleteTask((String)id, commandContext));
        } else {
            throw new ProcessEngineException("taskId and taskIds are null");
        }
        return null;
    }

    protected void deleteTask(String taskId, CommandContext commandContext) {
        TaskManager taskManager = commandContext.getTaskManager();
        TaskEntity task = taskManager.findTaskById(taskId);
        if (task != null) {
            if (task.getExecutionId() != null) {
                throw new ProcessEngineException("The task cannot be deleted because is part of a running process");
            }
            if (task.getCaseExecutionId() != null) {
                throw new ProcessEngineException("The task cannot be deleted because is part of a running case instance");
            }
            this.checkDeleteTask(task, commandContext);
            task.logUserOperation("Delete");
            String reason = this.deleteReason == null || this.deleteReason.isEmpty() ? "deleted" : this.deleteReason;
            task.delete(reason, this.cascade);
        } else if (this.cascade) {
            Context.getCommandContext().getHistoricTaskInstanceManager().deleteHistoricTaskInstanceById(taskId);
        }
    }

    protected void checkDeleteTask(TaskEntity task, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteTask(task);
        }
    }
}

