/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.util.Collections;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyManager;

public class DeletePropertyCmd
implements Command<Object> {
    protected String name;

    public DeletePropertyCmd(String name) {
        this.name = name;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        commandContext.getAuthorizationManager().checkOperatonAdminOrPermission(CommandChecker::checkDeleteProperty);
        PropertyManager propertyManager = commandContext.getPropertyManager();
        PropertyEntity propertyEntity = propertyManager.findPropertyById(this.name);
        if (propertyEntity != null) {
            propertyManager.delete(propertyEntity);
            commandContext.getOperationLogManager().logPropertyOperation("Delete", Collections.singletonList(new PropertyChange("name", null, this.name)));
        }
        return null;
    }
}

