/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.cmd.AbstractSetStateCmd;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.management.UpdateJobSuspensionStateBuilderImpl;
import org.operaton.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.JobDefinitionManager;
import org.operaton.bpm.engine.impl.persistence.entity.JobEntity;
import org.operaton.bpm.engine.impl.persistence.entity.JobManager;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.persistence.entity.SuspensionState;

public abstract class AbstractSetJobStateCmd
extends AbstractSetStateCmd {
    protected String jobId;
    protected String jobDefinitionId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processDefinitionTenantId;
    protected boolean processDefinitionTenantIdSet;

    protected AbstractSetJobStateCmd(UpdateJobSuspensionStateBuilderImpl builder) {
        super(false, null);
        this.jobId = builder.getJobId();
        this.jobDefinitionId = builder.getJobDefinitionId();
        this.processInstanceId = builder.getProcessInstanceId();
        this.processDefinitionId = builder.getProcessDefinitionId();
        this.processDefinitionKey = builder.getProcessDefinitionKey();
        this.processDefinitionTenantIdSet = builder.isProcessDefinitionTenantIdSet();
        this.processDefinitionTenantId = builder.getProcessDefinitionTenantId();
    }

    @Override
    protected void checkParameters(CommandContext commandContext) {
        if (this.jobId == null && this.jobDefinitionId == null && this.processInstanceId == null && this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new ProcessEngineException("Job id, job definition id, process instance id, process definition id nor process definition key cannot be null");
        }
    }

    @Override
    protected void checkAuthorization(CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            if (this.jobId != null) {
                JobManager jobManager = commandContext.getJobManager();
                JobEntity job = jobManager.findJobById(this.jobId);
                if (job == null) continue;
                String instanceId = job.getProcessInstanceId();
                if (instanceId != null) {
                    checker.checkUpdateProcessInstanceById(instanceId);
                    continue;
                }
                String definitionKey = job.getProcessDefinitionKey();
                if (definitionKey == null) continue;
                checker.checkUpdateProcessInstanceByProcessDefinitionKey(definitionKey);
                continue;
            }
            if (this.jobDefinitionId != null) {
                JobDefinitionManager jobDefinitionManager = commandContext.getJobDefinitionManager();
                JobDefinitionEntity jobDefinition = jobDefinitionManager.findById(this.jobDefinitionId);
                if (jobDefinition == null) continue;
                checker.checkUpdateProcessInstanceByProcessDefinitionKey(jobDefinition.getProcessDefinitionKey());
                continue;
            }
            if (this.processInstanceId != null) {
                checker.checkUpdateProcessInstanceById(this.processInstanceId);
                continue;
            }
            if (this.processDefinitionId != null) {
                checker.checkUpdateProcessInstanceByProcessDefinitionId(this.processDefinitionId);
                continue;
            }
            if (this.processDefinitionKey == null) continue;
            checker.checkUpdateProcessInstanceByProcessDefinitionKey(this.processDefinitionKey);
        }
    }

    @Override
    protected void updateSuspensionState(CommandContext commandContext, SuspensionState suspensionState) {
        JobManager jobManager = commandContext.getJobManager();
        if (this.jobId != null) {
            jobManager.updateJobSuspensionStateById(this.jobId, suspensionState);
        } else if (this.jobDefinitionId != null) {
            jobManager.updateJobSuspensionStateByJobDefinitionId(this.jobDefinitionId, suspensionState);
        } else if (this.processInstanceId != null) {
            jobManager.updateJobSuspensionStateByProcessInstanceId(this.processInstanceId, suspensionState);
        } else if (this.processDefinitionId != null) {
            jobManager.updateJobSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
        } else if (this.processDefinitionKey != null) {
            if (!this.processDefinitionTenantIdSet) {
                jobManager.updateJobSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
            } else {
                jobManager.updateJobSuspensionStateByProcessDefinitionKeyAndTenantId(this.processDefinitionKey, this.processDefinitionTenantId, suspensionState);
            }
        }
    }

    @Override
    protected void logUserOperation(CommandContext commandContext) {
        PropertyChange propertyChange = new PropertyChange("suspensionState", null, this.getNewSuspensionState().getName());
        commandContext.getOperationLogManager().logJobOperation(this.getLogEntryOperation(), this.jobId, this.jobDefinitionId, this.processInstanceId, this.processDefinitionId, this.processDefinitionKey, propertyChange);
    }
}

