/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.batch.job;

import java.util.Date;
import java.util.List;
import operatonjar.impl.com.google.gson.JsonObject;
import org.operaton.bpm.engine.impl.batch.AbstractBatchConfigurationObjectConverter;
import org.operaton.bpm.engine.impl.batch.DeploymentMappingJsonConverter;
import org.operaton.bpm.engine.impl.batch.DeploymentMappings;
import org.operaton.bpm.engine.impl.batch.SetJobRetriesBatchConfiguration;
import org.operaton.bpm.engine.impl.util.JsonUtil;

public class SetJobRetriesBatchConfigurationJsonConverter
extends AbstractBatchConfigurationObjectConverter<SetJobRetriesBatchConfiguration> {
    public static final SetJobRetriesBatchConfigurationJsonConverter INSTANCE = new SetJobRetriesBatchConfigurationJsonConverter();
    public static final String JOB_IDS = "jobIds";
    public static final String JOB_ID_MAPPINGS = "jobIdMappings";
    public static final String RETRIES = "retries";
    public static final String DUE_DATE = "dueDate";

    @Override
    public JsonObject writeConfiguration(SetJobRetriesBatchConfiguration configuration) {
        JsonObject json = JsonUtil.createObject();
        JsonUtil.addListField(json, JOB_IDS, configuration.getIds());
        JsonUtil.addListField(json, JOB_ID_MAPPINGS, DeploymentMappingJsonConverter.INSTANCE, configuration.getIdMappings());
        JsonUtil.addField(json, RETRIES, configuration.getRetries());
        if (configuration.isDueDateSet()) {
            Date dueDate = configuration.getDueDate();
            if (dueDate == null) {
                JsonUtil.addNullField(json, DUE_DATE);
            } else {
                JsonUtil.addDateField(json, DUE_DATE, dueDate);
            }
        }
        return json;
    }

    @Override
    public SetJobRetriesBatchConfiguration readConfiguration(JsonObject json) {
        boolean isDueDateSet = json.has(DUE_DATE);
        Date dueDate = null;
        if (isDueDateSet && !json.get(DUE_DATE).isJsonNull()) {
            dueDate = new Date(JsonUtil.getLong(json, DUE_DATE));
        }
        return new SetJobRetriesBatchConfiguration(this.readJobIds(json), this.readIdMappings(json), JsonUtil.getInt(json, RETRIES), dueDate, isDueDateSet);
    }

    protected List<String> readJobIds(JsonObject jsonObject) {
        return JsonUtil.asStringList(JsonUtil.getArray(jsonObject, JOB_IDS));
    }

    protected DeploymentMappings readIdMappings(JsonObject jsonObject) {
        return JsonUtil.asList(JsonUtil.getArray(jsonObject, JOB_ID_MAPPINGS), DeploymentMappingJsonConverter.INSTANCE, DeploymentMappings::new);
    }
}

