/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.batch.history;

import java.util.List;
import org.operaton.bpm.engine.batch.history.HistoricBatch;
import org.operaton.bpm.engine.batch.history.HistoricBatchQuery;
import org.operaton.bpm.engine.impl.AbstractQuery;
import org.operaton.bpm.engine.impl.HistoricBatchQueryProperty;
import org.operaton.bpm.engine.impl.Page;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class HistoricBatchQueryImpl
extends AbstractQuery<HistoricBatchQuery, HistoricBatch>
implements HistoricBatchQuery {
    private static final long serialVersionUID = 1L;
    protected String batchId;
    protected String type;
    protected Boolean completed;
    protected boolean isTenantIdSet;
    protected String[] tenantIds;

    public HistoricBatchQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricBatchQuery batchId(String batchId) {
        EnsureUtil.ensureNotNull("Batch id", (Object)batchId);
        this.batchId = batchId;
        return this;
    }

    public String getBatchId() {
        return this.batchId;
    }

    @Override
    public HistoricBatchQuery type(String type) {
        EnsureUtil.ensureNotNull("Type", (Object)type);
        this.type = type;
        return this;
    }

    @Override
    public HistoricBatchQuery completed(boolean completed) {
        this.completed = completed;
        return this;
    }

    @Override
    public HistoricBatchQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", (Object[])tenantIds);
        this.tenantIds = tenantIds;
        this.isTenantIdSet = true;
        return this;
    }

    public String[] getTenantIds() {
        return this.tenantIds;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }

    @Override
    public HistoricBatchQuery withoutTenantId() {
        this.tenantIds = null;
        this.isTenantIdSet = true;
        return this;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public HistoricBatchQuery orderById() {
        return (HistoricBatchQuery)this.orderBy(HistoricBatchQueryProperty.ID);
    }

    @Override
    public HistoricBatchQuery orderByStartTime() {
        return (HistoricBatchQuery)this.orderBy(HistoricBatchQueryProperty.START_TIME);
    }

    @Override
    public HistoricBatchQuery orderByEndTime() {
        return (HistoricBatchQuery)this.orderBy(HistoricBatchQueryProperty.END_TIME);
    }

    @Override
    public HistoricBatchQuery orderByTenantId() {
        return (HistoricBatchQuery)this.orderBy(HistoricBatchQueryProperty.TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getHistoricBatchManager().findBatchCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricBatch> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getHistoricBatchManager().findBatchesByQueryCriteria(this, page);
    }
}

