/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl;

import org.operaton.bpm.engine.identity.Tenant;
import org.operaton.bpm.engine.identity.TenantQuery;
import org.operaton.bpm.engine.impl.AbstractQuery;
import org.operaton.bpm.engine.impl.TenantQueryProperty;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public abstract class TenantQueryImpl
extends AbstractQuery<TenantQuery, Tenant>
implements TenantQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String[] ids;
    protected String name;
    protected String nameLike;
    protected String userId;
    protected String groupId;
    protected boolean includingGroups;

    protected TenantQueryImpl() {
    }

    protected TenantQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public TenantQuery tenantId(String id) {
        EnsureUtil.ensureNotNull("tenant ud", (Object)id);
        this.id = id;
        return this;
    }

    @Override
    public TenantQuery tenantIdIn(String ... ids) {
        EnsureUtil.ensureNotNull("tenant ids", (Object[])ids);
        this.ids = ids;
        return this;
    }

    @Override
    public TenantQuery tenantName(String name) {
        EnsureUtil.ensureNotNull("tenant name", (Object)name);
        this.name = name;
        return this;
    }

    @Override
    public TenantQuery tenantNameLike(String nameLike) {
        EnsureUtil.ensureNotNull("tenant name like", (Object)nameLike);
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public TenantQuery userMember(String userId) {
        EnsureUtil.ensureNotNull("user id", (Object)userId);
        this.userId = userId;
        return this;
    }

    @Override
    public TenantQuery groupMember(String groupId) {
        EnsureUtil.ensureNotNull("group id", (Object)groupId);
        this.groupId = groupId;
        return this;
    }

    @Override
    public TenantQuery includingGroupsOfUser(boolean includingGroups) {
        this.includingGroups = includingGroups;
        return this;
    }

    @Override
    public TenantQuery orderByTenantId() {
        return (TenantQuery)this.orderBy(TenantQueryProperty.TENANT_ID);
    }

    @Override
    public TenantQuery orderByTenantName() {
        return (TenantQuery)this.orderBy(TenantQueryProperty.NAME);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String[] getIds() {
        return this.ids;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean isIncludingGroups() {
        return this.includingGroups;
    }
}

